/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.modifier;

import io.github.mmm.base.exception.DuplicateObjectException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CodeVisibility
implements Comparable<CodeVisibility> {
    private static final Map<String, CodeVisibility> VISIBILITY_MAP = new HashMap<String, CodeVisibility>();
    public static final CodeVisibility PUBLIC = new CodeVisibility("public", 0);
    public static final CodeVisibility PRIVATE = new CodeVisibility("private", 100);
    public static final CodeVisibility PROTECTED = new CodeVisibility("protected", 10);
    public static final CodeVisibility DEFAULT = new CodeVisibility("", 20);
    private final String value;
    private final int order;

    public CodeVisibility(String value, int order) {
        assert (value != null);
        this.value = value;
        this.order = order;
        if (VISIBILITY_MAP.containsKey(value)) {
            throw new DuplicateObjectException((Object)this, (Object)value, (Object)VISIBILITY_MAP.get(value));
        }
        VISIBILITY_MAP.put(value, this);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isStrongerOrEqualTo(CodeVisibility visibility) {
        if (visibility == null) {
            return false;
        }
        return this.order >= visibility.order;
    }

    public boolean isWeakerOrEqualTo(CodeVisibility visibility) {
        if (visibility == null) {
            return false;
        }
        return this.order <= visibility.order;
    }

    @Override
    public int compareTo(CodeVisibility visibility) {
        if (visibility == null) {
            return -1;
        }
        return this.order - visibility.order;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CodeVisibility other = (CodeVisibility)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static CodeVisibility of(int javaModifiers) {
        if (Modifier.isPublic(javaModifiers)) {
            return PUBLIC;
        }
        if (Modifier.isPrivate(javaModifiers)) {
            return PRIVATE;
        }
        if (Modifier.isProtected(javaModifiers)) {
            return PROTECTED;
        }
        return DEFAULT;
    }

    public static CodeVisibility of(String visiblity) {
        return VISIBILITY_MAP.get(visiblity);
    }
}

