/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.object;

import io.github.mmm.code.api.CodeFile;
import io.github.mmm.code.api.CodePackage;
import io.github.mmm.code.api.CodePathElement;
import io.github.mmm.code.api.annotation.CodeAnnotation;
import io.github.mmm.code.api.arg.CodeParameter;
import io.github.mmm.code.api.arg.CodeReturn;
import io.github.mmm.code.api.block.CodeBlock;
import io.github.mmm.code.api.block.CodeBlockBody;
import io.github.mmm.code.api.block.CodeBlockFor;
import io.github.mmm.code.api.block.CodeBlockIf;
import io.github.mmm.code.api.block.CodeBlockStatement;
import io.github.mmm.code.api.comment.CodeComment;
import io.github.mmm.code.api.doc.CodeDoc;
import io.github.mmm.code.api.element.CodeElement;
import io.github.mmm.code.api.expression.CodeArrayInstatiation;
import io.github.mmm.code.api.expression.CodeCastExpression;
import io.github.mmm.code.api.expression.CodeCondition;
import io.github.mmm.code.api.expression.CodeConstant;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.expression.CodeExpressionCondition;
import io.github.mmm.code.api.expression.CodeForEachExpression;
import io.github.mmm.code.api.expression.CodeForExpression;
import io.github.mmm.code.api.expression.CodeForLoopExpression;
import io.github.mmm.code.api.expression.CodeOperationInvocation;
import io.github.mmm.code.api.expression.CodeOperatorExpression;
import io.github.mmm.code.api.expression.CodeTernaryExpression;
import io.github.mmm.code.api.expression.CodeVariable;
import io.github.mmm.code.api.imports.CodeImport;
import io.github.mmm.code.api.imports.CodeImportItem;
import io.github.mmm.code.api.member.CodeConstructor;
import io.github.mmm.code.api.member.CodeField;
import io.github.mmm.code.api.member.CodeMethod;
import io.github.mmm.code.api.member.CodeOperation;
import io.github.mmm.code.api.member.CodeProperty;
import io.github.mmm.code.api.statement.CodeAssignment;
import io.github.mmm.code.api.statement.CodeAtomicStatement;
import io.github.mmm.code.api.statement.CodeLocalVariable;
import io.github.mmm.code.api.statement.CodeReturnStatement;
import io.github.mmm.code.api.statement.CodeStatement;
import io.github.mmm.code.api.type.CodeArrayType;
import io.github.mmm.code.api.type.CodeComposedType;
import io.github.mmm.code.api.type.CodeGenericType;
import io.github.mmm.code.api.type.CodeParameterizedType;
import io.github.mmm.code.api.type.CodeType;
import io.github.mmm.code.api.type.CodeTypePlaceholder;
import io.github.mmm.code.api.type.CodeTypeVariable;
import io.github.mmm.code.api.type.CodeTypeWildcard;

public abstract class CodeVisitor {
    public void visitPackage(CodePackage pkg) {
        this.doVisitElement(pkg);
        for (CodePathElement codePathElement : pkg.getChildren().getDeclared()) {
            if (codePathElement.isFile()) {
                this.visitFile((CodeFile)codePathElement);
                continue;
            }
            this.visitPackage((CodePackage)codePathElement);
        }
    }

    public void visitFile(CodeFile file) {
        this.doVisitElement(file);
        if (this.isVisitImports()) {
            for (CodeImport codeImport : file.getImports()) {
                this.visitImport(codeImport);
            }
        }
        for (CodeType codeType : file.getTypes()) {
            this.visitTypeDeclaration(codeType);
        }
    }

    protected boolean isVisitImports() {
        return true;
    }

    protected void visitImport(CodeImport importStatement) {
        for (CodeImportItem item : importStatement.getItems()) {
            this.visitImportItem(item);
        }
    }

    protected void visitImportItem(CodeImportItem item) {
    }

    protected boolean isVisitComments() {
        return false;
    }

    protected void visitComment(CodeComment comment) {
    }

    protected boolean isVisitDocs() {
        return false;
    }

    protected void visitDoc(CodeDoc doc) {
    }

    protected boolean isVisitAnnotations() {
        return true;
    }

    protected void visitAnnotation(CodeAnnotation annotation) {
        if (annotation == null) {
            return;
        }
        this.visitGenericType(annotation.getType());
    }

    public void visitTypeDeclaration(CodeType type) {
        this.doVisitElement(type);
        if (this.isVisitBlocks()) {
            this.doVisitBlock(type.getStaticInitializer());
            this.doVisitBlock(type.getNonStaticInitializer());
        }
        if (this.isVisitSuperTypes()) {
            for (CodeGenericType superType : type.getSuperTypes().getDeclared()) {
                this.visitSuperType(superType);
            }
        }
        if (this.isVisitFields()) {
            for (CodeField field : type.getFields().getDeclared()) {
                this.visitField(field);
            }
        }
        if (this.isVisitConstructors()) {
            for (CodeConstructor constructor : type.getConstructors().getDeclared()) {
                this.visitConstructor(constructor);
            }
        }
        if (this.isVisitMethods()) {
            for (CodeMethod metohd : type.getMethods()) {
                this.visitMethod(metohd);
            }
        }
        if (this.isVisitProperties()) {
            for (CodeProperty property : type.getProperties()) {
                this.visitProperty(property);
            }
        }
    }

    protected void visitTypeReference(CodeType type) {
    }

    protected boolean isVisitSuperTypes() {
        return true;
    }

    protected void visitSuperType(CodeGenericType superType) {
        this.visitGenericType(superType);
    }

    protected boolean isVisitFields() {
        return true;
    }

    protected void visitField(CodeField field) {
        this.doVisitElement(field);
        this.visitGenericType(field.getType());
        CodeExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.visitExpression(initializer);
        }
    }

    protected boolean isVisitConstructors() {
        return true;
    }

    protected void visitConstructor(CodeConstructor constructor) {
        this.doVisitOperation(constructor);
    }

    protected boolean isVisitMethods() {
        return true;
    }

    protected void visitMethod(CodeMethod method) {
        this.doVisitOperation(method);
        this.visitReturns(method.getReturns());
    }

    protected void visitReturns(CodeReturn returns) {
        this.doVisitElement(returns);
        CodeGenericType type = returns.getType();
        if (type != null) {
            this.visitGenericType(type);
        }
    }

    protected void doVisitOperation(CodeOperation operation) {
        if (operation == null) {
            return;
        }
        this.doVisitElement(operation);
        if (this.isVisitBodies()) {
            this.visitBody(operation.getBody());
        }
        if (this.isVisitParameters()) {
            for (CodeParameter parameter : operation.getParameters().getDeclared()) {
                this.visitParameter(parameter);
            }
        }
    }

    protected boolean isVisitProperties() {
        return false;
    }

    protected void visitProperty(CodeProperty property) {
        this.doVisitElement(property);
    }

    protected boolean isVisitParameters() {
        return true;
    }

    protected void visitParameter(CodeParameter parameter) {
        this.doVisitElement(parameter);
        CodeGenericType type = parameter.getType();
        if (type != null) {
            this.visitGenericType(type);
        }
    }

    protected boolean isVisitBodies() {
        return true;
    }

    protected void visitBody(CodeBlockBody body) {
        if (this.isVisitBlocks()) {
            this.doVisitBlock(body);
        }
    }

    protected boolean isVisitBlocks() {
        return true;
    }

    protected void doVisitBlock(CodeBlock block) {
        for (CodeStatement statement : block.getStatements()) {
            this.visitStatement(statement);
        }
    }

    protected boolean isVisitStatements() {
        return true;
    }

    protected void visitStatement(CodeStatement statement) {
        if (statement instanceof CodeAssignment) {
            this.visitAssignment((CodeAssignment)statement);
        } else if (statement instanceof CodeReturnStatement) {
            this.visitReturnStatement((CodeReturnStatement)statement);
        } else if (statement instanceof CodeBlockStatement && this.isVisitBlocks()) {
            this.visitBlockStatement((CodeBlockStatement)statement);
        }
    }

    protected void visitBlockStatement(CodeBlockStatement block) {
        if (block instanceof CodeBlockFor) {
            this.visitBlockFor((CodeBlockFor)block);
        } else if (block instanceof CodeBlockIf) {
            this.visitBlockIf((CodeBlockIf)block);
        }
    }

    protected void visitBlockIf(CodeBlockIf block) {
        CodeCondition condition;
        if (this.isVisitExpressions() && (condition = block.getCondition()) != null) {
            this.visitCondition(condition);
        }
    }

    protected void visitBlockFor(CodeBlockFor block) {
        CodeForExpression expression;
        if (this.isVisitExpressions() && (expression = block.getExpression()) != null) {
            this.visitForExpression(expression);
        }
        this.doVisitBlock(block);
    }

    protected void visitReturnStatement(CodeReturnStatement statement) {
        CodeExpression expression;
        if (this.isVisitExpressions() && (expression = statement.getExpression()) != null) {
            this.visitExpression(expression);
        }
    }

    protected void visitAssignment(CodeAssignment statement) {
        CodeExpression expression;
        CodeVariable variable;
        if (this.isVisitVariables() && (variable = statement.getVariable()) instanceof CodeLocalVariable) {
            this.visitLocalVariable((CodeLocalVariable)variable);
        }
        if (this.isVisitExpressions() && (expression = statement.getExpression()) != null) {
            this.visitExpression(expression);
        }
    }

    protected boolean isVisitVariables() {
        return true;
    }

    protected void visitLocalVariable(CodeLocalVariable variable) {
    }

    protected boolean isVisitExpressions() {
        return true;
    }

    protected void visitCondition(CodeCondition condition) {
        this.doVisitExpression(condition);
    }

    protected void doVisitExpression(CodeExpression expression) {
    }

    protected void visitExpression(CodeExpression expression) {
        if (expression instanceof CodeConstant) {
            this.visitConstant((CodeConstant)expression);
        } else if (expression instanceof CodeOperatorExpression) {
            this.visitOperatorExpression((CodeOperatorExpression)expression);
        } else if (expression instanceof CodeOperationInvocation) {
            this.visitOperationInvocation((CodeOperationInvocation)expression);
        } else if (expression instanceof CodeCondition) {
            this.visitCondition((CodeCondition)expression);
        } else if (expression instanceof CodeCastExpression) {
            this.visitCastExpression((CodeCastExpression)expression);
        } else if (expression instanceof CodeExpressionCondition) {
            this.visitExpressionCondition((CodeExpressionCondition)expression);
        } else if (expression instanceof CodeTernaryExpression) {
            this.visitTernaryExpression((CodeTernaryExpression)expression);
        } else if (expression instanceof CodeArrayInstatiation) {
            this.visitArrayInstatiation((CodeArrayInstatiation)expression);
        }
    }

    protected void visitArrayInstatiation(CodeArrayInstatiation expression) {
        this.doVisitExpression(expression);
        for (CodeExpression value : expression.getValues()) {
            this.visitExpression(value);
        }
    }

    protected void visitOperationInvocation(CodeOperationInvocation expression) {
        this.doVisitExpression(expression);
        for (CodeExpression codeExpression : expression.getArguments()) {
            this.visitExpression(codeExpression);
        }
        for (CodeGenericType codeGenericType : expression.getTypeParameters()) {
            this.visitGenericType(codeGenericType);
        }
    }

    protected void visitTernaryExpression(CodeTernaryExpression expression) {
        CodeExpression elseArg;
        CodeExpression ifArg;
        this.doVisitExpression(expression);
        CodeCondition condition = expression.getCondition();
        if (condition != null) {
            this.visitCondition(condition);
        }
        if ((ifArg = expression.getIfArg()) != null) {
            this.visitExpression(ifArg);
        }
        if ((elseArg = expression.getElseArg()) != null) {
            this.visitExpression(elseArg);
        }
    }

    protected void visitExpressionCondition(CodeExpressionCondition expression) {
        this.doVisitExpression(expression);
        CodeExpression wrappedExpression = expression.getExpression();
        if (wrappedExpression != null) {
            this.visitExpression(wrappedExpression);
        }
    }

    protected void visitOperatorExpression(CodeOperatorExpression expression) {
        this.doVisitExpression(expression);
        for (CodeExpression codeExpression : expression.getArguments()) {
            this.visitExpression(codeExpression);
        }
    }

    protected void visitCastExpression(CodeCastExpression expression) {
        this.doVisitExpression(expression);
        CodeGenericType type = expression.getType();
        if (type != null) {
            this.visitGenericType(type);
        }
    }

    protected void visitConstant(CodeConstant constant) {
        this.doVisitExpression(constant);
    }

    protected void visitForExpression(CodeForExpression expression) {
        if (expression instanceof CodeForLoopExpression) {
            this.visitForLoopExpression((CodeForLoopExpression)expression);
        } else if (expression instanceof CodeForEachExpression) {
            this.visitForEachExpreesion((CodeForEachExpression)expression);
        }
    }

    protected void visitForEachExpreesion(CodeForEachExpression expression) {
        CodeExpression iterable;
        CodeLocalVariable variable;
        if (this.isVisitVariables() && (variable = expression.getVariable()) != null) {
            this.visitLocalVariable(variable);
        }
        if (this.isVisitExpressions() && (iterable = expression.getExpression()) != null) {
            this.visitExpression(iterable);
        }
    }

    protected void visitForLoopExpression(CodeForLoopExpression expression) {
        CodeCondition condition;
        CodeAtomicStatement statement;
        if (this.isVisitStatements() && (statement = expression.getInit()) != null) {
            this.visitStatement(statement);
        }
        if (this.isVisitExpressions() && (condition = expression.getCondition()) != null) {
            this.visitCondition(condition);
        }
        if (this.isVisitStatements() && (statement = expression.getUpdate()) != null) {
            this.visitStatement(statement);
        }
    }

    protected void doVisitElement(CodeElement element) {
        if (this.isVisitComments()) {
            this.visitComment(element.getComment());
        }
        if (this.isVisitDocs()) {
            this.visitDoc(element.getDoc());
        }
        if (this.isVisitAnnotations()) {
            for (CodeAnnotation annotation : element.getAnnotations()) {
                this.visitAnnotation(annotation);
            }
        }
    }

    protected void visitGenericType(CodeGenericType type) {
        if (type instanceof CodeType) {
            this.visitTypeReference((CodeType)type);
        } else if (type instanceof CodeArrayType) {
            this.visitArrayType((CodeArrayType)type);
        } else if (type instanceof CodeParameterizedType) {
            this.visitParameterizedType((CodeParameterizedType)type);
        } else if (type instanceof CodeTypeVariable) {
            this.visitTypeVariable((CodeTypeVariable)type);
        } else if (type instanceof CodeTypeWildcard) {
            this.visitTypeWildcard((CodeTypeWildcard)type);
        } else if (type instanceof CodeComposedType) {
            this.visitComposedType((CodeComposedType)type);
        }
    }

    protected void visitComposedType(CodeComposedType type) {
        if (type == null) {
            return;
        }
        this.doVisitElement(type);
        for (CodeGenericType codeGenericType : type.getTypes()) {
            this.visitGenericType(codeGenericType);
        }
    }

    protected void visitParameterizedType(CodeParameterizedType type) {
        if (type == null) {
            return;
        }
        this.doVisitElement(type);
        for (CodeGenericType parameter : type.getTypeParameters().getDeclared()) {
            if (parameter == type) continue;
            this.visitGenericType(parameter);
        }
    }

    protected void visitArrayType(CodeArrayType type) {
        this.doVisitElement(type);
        CodeGenericType componentType = type.getComponentType();
        if (componentType != null) {
            this.visitGenericType(componentType);
        }
    }

    protected void doVisitTypePlaceholder(CodeTypePlaceholder type) {
        this.doVisitElement(type);
        CodeGenericType bound = type.getBound();
        if (bound != null) {
            this.visitGenericType(bound);
        }
    }

    protected void visitTypeVariable(CodeTypeVariable type) {
        this.doVisitTypePlaceholder(type);
    }

    protected void visitTypeWildcard(CodeTypeWildcard type) {
        this.doVisitTypePlaceholder(type);
    }
}

