/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.api.type;

import java.util.Objects;

public final class CodeTypeCategory {
    public static final CodeTypeCategory CLASS = new CodeTypeCategory("class");
    public static final CodeTypeCategory INTERFACE = new CodeTypeCategory("interface");
    public static final CodeTypeCategory ENUMERAION = new CodeTypeCategory("enumeration");
    public static final CodeTypeCategory ANNOTATION = new CodeTypeCategory("annotation");
    public static final CodeTypeCategory RECORD = new CodeTypeCategory("record");
    private final String value;

    public CodeTypeCategory(String value) {
        assert (value != null);
        this.value = value;
    }

    public boolean isClass() {
        return this == CLASS;
    }

    public boolean isInterface() {
        return this == INTERFACE;
    }

    public boolean isInterfaceOrAnnotation() {
        return this == INTERFACE || this == ANNOTATION;
    }

    public boolean isEnumeration() {
        return this == ENUMERAION;
    }

    public boolean isAnnotation() {
        return this == ANNOTATION;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CodeTypeCategory other = (CodeTypeCategory)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

