/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java;

import io.github.mmm.code.api.CodeName;
import io.github.mmm.code.api.element.CodeElementWithDeclaringType;
import io.github.mmm.code.api.element.CodeElementWithTypeVariables;
import io.github.mmm.code.api.node.CodeNode;
import io.github.mmm.code.api.node.CodeNodeItem;
import io.github.mmm.code.api.type.CodeTypeVariable;
import io.github.mmm.code.base.AbstractBaseContextWithCache;
import io.github.mmm.code.base.BaseContext;
import io.github.mmm.code.base.arg.BaseOperationArg;
import io.github.mmm.code.base.element.BaseElement;
import io.github.mmm.code.base.element.BaseElementWithDeclaringType;
import io.github.mmm.code.base.loader.BaseLoader;
import io.github.mmm.code.base.member.BaseOperation;
import io.github.mmm.code.base.node.BaseNodeItem;
import io.github.mmm.code.base.source.BaseSource;
import io.github.mmm.code.base.source.BaseSourceImpl;
import io.github.mmm.code.base.source.BaseSourceProvider;
import io.github.mmm.code.base.type.BaseArrayType;
import io.github.mmm.code.base.type.BaseGenericType;
import io.github.mmm.code.base.type.BaseParameterizedType;
import io.github.mmm.code.base.type.BaseType;
import io.github.mmm.code.base.type.BaseTypeVariable;
import io.github.mmm.code.base.type.BaseTypeVariables;
import io.github.mmm.code.base.type.BaseTypeWildcard;
import io.github.mmm.code.impl.java.JavaRootContext;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.CodeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaContext
extends AbstractBaseContextWithCache {
    private static final Logger LOG = LoggerFactory.getLogger(JavaContext.class);

    protected JavaContext(BaseSourceImpl source) {
        super(source);
    }

    public JavaContext(BaseSourceImpl source, BaseSourceProvider sourceProvider) {
        super(source, sourceProvider);
    }

    public abstract JavaRootContext getRootContext();

    protected BaseType getTypeFromCache(String qualifiedName) {
        return super.getTypeFromCache(qualifiedName);
    }

    public BaseGenericType getType(Type type, CodeElementWithDeclaringType declaringElement) {
        if (type instanceof Class) {
            return this.getType((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new BaseParameterizedType((BaseElement)declaringElement, parameterizedType);
        }
        if (type instanceof TypeVariable) {
            BaseTypeVariable typeVariable;
            TypeVariable typeVar = (TypeVariable)type;
            if (declaringElement instanceof BaseType) {
                BaseType declaringType = (BaseType)declaringElement;
                assert (typeVar.getGenericDeclaration() == declaringType.getReflectiveObject());
                return new BaseTypeVariable(declaringType.getTypeParameters(), typeVar);
            }
            if (declaringElement instanceof BaseOperation) {
                BaseOperation operation = (BaseOperation)declaringElement;
                if (typeVar.getGenericDeclaration() == operation.getReflectiveObject()) {
                    return new BaseTypeVariable(operation.getTypeParameters(), typeVar);
                }
            }
            if ((typeVariable = (BaseTypeVariable)JavaContext.findTypeVariable((CodeNode)declaringElement, typeVar.getName())) != null) {
                return typeVariable;
            }
            LOG.warn("Could not find type variable {} in {}", (Object)typeVar, (Object)declaringElement);
            return new BaseTypeVariable((BaseTypeVariables)declaringElement.getDeclaringType().getTypeParameters(), typeVar);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Object parent = declaringElement instanceof BaseParameterizedType ? ((BaseParameterizedType)declaringElement).getTypeParameters() : (BaseNodeItem)declaringElement;
            return new BaseTypeWildcard((CodeNodeItem)parent, wildcard);
        }
        if (type instanceof GenericArrayType) {
            return new BaseArrayType((BaseElementWithDeclaringType)declaringElement, type);
        }
        throw new IllegalStateException(type.getClass().getSimpleName());
    }

    private static CodeTypeVariable findTypeVariable(CodeNode node, String name) {
        CodeElementWithTypeVariables elementWithTypeVariables = JavaContext.findElementWithTypeVariables(node);
        if (elementWithTypeVariables != null) {
            return elementWithTypeVariables.getTypeParameters().get(name, true);
        }
        return null;
    }

    private static CodeElementWithTypeVariables findElementWithTypeVariables(CodeNode node) {
        if (node instanceof CodeElementWithTypeVariables) {
            return (CodeElementWithTypeVariables)node;
        }
        if (node instanceof BaseOperationArg) {
            BaseOperationArg arg = (BaseOperationArg)node;
            BaseOperation operation = arg.getDeclaringOperation();
            if (operation != null) {
                return operation;
            }
            return arg.getDeclaringType();
        }
        if (node instanceof BaseGenericType) {
            return JavaContext.findElementWithTypeVariables(node.getParent());
        }
        if (node instanceof BaseTypeVariables) {
            return JavaContext.findElementWithTypeVariables(node.getParent());
        }
        throw new IllegalStateException(node.getClass().getSimpleName());
    }

    public abstract ClassLoader getClassLoader();

    protected class JavaClassLoader
    implements BaseLoader {
        private final ClassLoader classLoader;

        public JavaClassLoader() {
            this(Thread.currentThread().getContextClassLoader());
        }

        public JavaClassLoader(ClassLoader classloader) {
            this.classLoader = classloader;
        }

        public BaseSource getSource() {
            return JavaContext.this.getSource();
        }

        public BaseContext getContext() {
            return JavaContext.this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public BaseType getType(String qualifiedName) {
            BaseType type;
            if (this.classLoader != null) {
                Class<?> clazz = null;
                try {
                    clazz = this.classLoader.loadClass(qualifiedName);
                    if (clazz.isArray()) {
                        throw new IllegalArgumentException(qualifiedName);
                    }
                    return (BaseType)this.getContext().getType(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    if (LOG.isTraceEnabled()) {
                        LOG.debug("Class {} not found.", (Object)qualifiedName, (Object)e);
                    }
                    LOG.debug("Class {} not found: {}", (Object)qualifiedName, (Object)e.toString());
                }
            }
            if ((type = this.getSource().getLoader().getType(JavaContext.this.parseName(qualifiedName))) != null) {
                type.setImmutable();
            }
            return type;
        }

        public BaseType getType(CodeName qualifiedName) {
            return this.getType(qualifiedName.getFullName());
        }

        public BaseGenericType getType(Class<?> clazz) {
            if (clazz.isArray()) {
                BaseGenericType componentType = this.getType(clazz.getComponentType());
                return componentType.createArray();
            }
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            BaseSource source = JavaContext.this.getOrCreateSource(codeSource);
            if (source == null) {
                return null;
            }
            return source.getLoader().getType(clazz);
        }
    }
}

