/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression;

import io.github.mmm.code.api.expression.CodeConstant;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.operator.CodeUnaryOperator;
import io.github.mmm.code.base.expression.BaseUnaryOperatorExpression;
import io.github.mmm.code.impl.java.expression.JavaExpression;
import io.github.mmm.code.impl.java.expression.constant.JavaConstant;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralBoolean;

public class JavaUnaryOperatorExpression
extends BaseUnaryOperatorExpression
implements JavaExpression {
    public JavaUnaryOperatorExpression(CodeUnaryOperator operator, CodeExpression argument) {
        super(operator, argument);
    }

    @Override
    public JavaConstant<?> evaluate() {
        CodeConstant literal;
        String op = this.getOperator().getName();
        if ("!".equals(op)) {
            CodeConstant constant = this.getArgument().evaluate();
            if (constant != null) {
                Object value = constant.getValue();
                if (Boolean.TRUE.equals(value)) {
                    return JavaLiteralBoolean.FALSE;
                }
                if (Boolean.FALSE.equals(value)) {
                    return JavaLiteralBoolean.TRUE;
                }
            }
        } else if ("~".equals(op) && (literal = this.getArgument().evaluate()) instanceof JavaConstant) {
            return this.complement((Object)((JavaConstant)literal));
        }
        return null;
    }

    private <T> JavaConstant<T> complement(JavaConstant<T> literal) {
        T value = literal.getValue();
        if ((value = this.complement(value)) != null) {
            return literal.withValue(value);
        }
        return null;
    }

    private <T> T complement(T value) {
        Number result = null;
        if (value instanceof Integer) {
            result = ~((Integer)value).intValue();
        } else if (value instanceof Long) {
            result = (Long)value ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (value instanceof Short) {
            result = ~((Short)value).shortValue();
        } else if (value instanceof Byte) {
            result = ~((Byte)value).byteValue();
        }
        return (T)result;
    }
}

