/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.constant;

import io.github.mmm.code.api.expression.CodeConstant;
import io.github.mmm.code.api.language.CodeLanguage;
import io.github.mmm.code.base.expression.BaseExpression;
import io.github.mmm.code.impl.java.expression.JavaExpression;
import io.github.mmm.code.impl.java.expression.constant.JavaFactoryConstant;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralClass;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralNull;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralString;
import java.io.IOException;

public abstract class JavaConstant<T>
extends BaseExpression
implements CodeConstant,
JavaExpression {
    private final T value;

    public JavaConstant(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends T> getJavaClass() {
        return this.value.getClass();
    }

    public boolean isPrimitive() {
        return false;
    }

    @Override
    public JavaConstant<T> evaluate() {
        return this;
    }

    public abstract String getSourceCode();

    protected void doWrite(Appendable sink, String newline, String defaultIndent, String currentIndent, CodeLanguage language) throws IOException {
        sink.append(this.getSourceCode());
    }

    public abstract JavaConstant<T> withValue(T var1);

    public static JavaConstant<?> of(Object value, boolean primitive) {
        if (value == null) {
            assert (!primitive);
            return JavaLiteralNull.NULL;
        }
        if (primitive) {
            return JavaLiteral.of(value);
        }
        if (value instanceof String) {
            return JavaLiteralString.of((String)value);
        }
        if (value instanceof Class) {
            return JavaLiteralClass.of((Class)value);
        }
        return JavaFactoryConstant.of(value);
    }
}

