/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.constant;

import io.github.mmm.code.impl.java.expression.constant.JavaConstant;
import io.github.mmm.code.impl.java.expression.constant.JavaFactoryConstant;

public class JavaConstantBoolean
extends JavaFactoryConstant<Boolean> {
    public static final JavaConstantBoolean TRUE = new JavaConstantBoolean(Boolean.TRUE);
    public static final JavaConstantBoolean FALSE = new JavaConstantBoolean(Boolean.FALSE);

    private JavaConstantBoolean(Boolean value) {
        super(value);
    }

    @Override
    public JavaConstant<Boolean> withValue(Boolean newValue) {
        return new JavaConstantBoolean(newValue);
    }

    @Override
    public String getSourceCode() {
        return "Boolean.valueOf(" + ((Boolean)this.getValue()).toString() + ")";
    }

    public static JavaConstant<Boolean> of(Boolean value) {
        if (value.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }
}

