/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.constant;

import io.github.mmm.code.impl.java.expression.constant.JavaConstant;

public class JavaEnumConstant<T extends Enum<T>>
extends JavaConstant<T> {
    private final boolean unqualified;

    private JavaEnumConstant(T value, boolean qualified) {
        super(value);
        this.unqualified = qualified;
    }

    @Override
    public String getSourceCode() {
        Enum value = (Enum)this.getValue();
        Class<?> enumClass = value.getClass();
        String name = this.unqualified ? enumClass.getSimpleName() : enumClass.getName();
        return name + "." + value.name();
    }

    @Override
    public JavaConstant<T> withValue(T newValue) {
        return new JavaEnumConstant<T>(newValue, this.unqualified);
    }

    public static <T extends Enum<T>> JavaEnumConstant<T> of(T value, boolean unqualified) {
        return new JavaEnumConstant<T>(value, unqualified);
    }
}

