/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.parser;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.code.api.annotation.CodeAnnotation;
import io.github.mmm.code.api.arg.CodeParameter;
import io.github.mmm.code.api.block.CodeBlockBody;
import io.github.mmm.code.api.block.CodeBlockInitializer;
import io.github.mmm.code.api.comment.CodeComment;
import io.github.mmm.code.api.element.CodeElement;
import io.github.mmm.code.api.element.CodeElementWithTypeVariables;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.member.CodeField;
import io.github.mmm.code.api.member.CodeMember;
import io.github.mmm.code.api.member.CodeOperation;
import io.github.mmm.code.api.modifier.CodeModifiers;
import io.github.mmm.code.api.node.CodeFunction;
import io.github.mmm.code.api.statement.CodeStatement;
import io.github.mmm.code.api.type.CodeGenericType;
import io.github.mmm.code.api.type.CodeType;
import io.github.mmm.code.api.type.CodeTypeCategory;
import io.github.mmm.code.base.BaseFile;
import io.github.mmm.code.base.annoation.BaseAnnotations;
import io.github.mmm.code.base.arg.BaseExceptions;
import io.github.mmm.code.base.arg.BaseParameters;
import io.github.mmm.code.base.block.BaseBlockBody;
import io.github.mmm.code.base.block.BaseBlockInitializer;
import io.github.mmm.code.base.doc.BaseDocParser;
import io.github.mmm.code.base.element.BaseElement;
import io.github.mmm.code.base.member.BaseConstructor;
import io.github.mmm.code.base.member.BaseConstructors;
import io.github.mmm.code.base.member.BaseField;
import io.github.mmm.code.base.member.BaseMember;
import io.github.mmm.code.base.member.BaseMethod;
import io.github.mmm.code.base.member.BaseOperation;
import io.github.mmm.code.base.statement.BaseTextStatement;
import io.github.mmm.code.base.type.BaseGenericType;
import io.github.mmm.code.base.type.BaseType;
import io.github.mmm.code.base.type.BaseTypeVariable;
import io.github.mmm.code.base.type.BaseTypeVariables;
import io.github.mmm.code.impl.java.parser.JavaGenericTypeFromSource;
import io.github.mmm.code.impl.java.parser.JavaSourceCodeReaderLowlevel;
import io.github.mmm.code.impl.java.parser.JavaTypeVariablesFromSource;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceCodeReaderHighlevel
extends JavaSourceCodeReaderLowlevel {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSourceCodeReaderHighlevel.class);
    private BaseDocParser docParser = new BaseDocParser();

    public JavaSourceCodeReaderHighlevel() {
        this(4096);
    }

    public JavaSourceCodeReaderHighlevel(int capacity) {
        super(capacity);
    }

    public BaseType parse(Reader reader, BaseFile javaFile) {
        if (this.file != null) {
            throw new IllegalStateException();
        }
        this.setReader(reader);
        this.file = javaFile;
        this.parsePackage();
        this.parseImports();
        this.parseTypes();
        this.file = null;
        return javaFile.getType();
    }

    private void parsePackage() {
        String expectedPkg;
        this.consume();
        String actualPkg = "";
        char c = this.peek();
        if (c == 'p' && this.expect("package")) {
            this.skipWhile(CharFilter.WHITESPACE);
            actualPkg = this.readUntil(';', true).trim();
        }
        if (!actualPkg.equals(expectedPkg = this.file.getParentPackage().getQualifiedName())) {
            LOG.warn("Expected package '{}' for file '{}' but found package '{}'", new Object[]{expectedPkg, this.file.getSimpleName(), actualPkg});
        }
        this.file.setComment(this.getElementComment());
        this.elementComment = null;
    }

    private void parseImports() {
        this.consume();
        while (this.peek() == 'i') {
            if (!this.expect("import")) continue;
            this.parseWhitespacesAndComments();
            boolean staticImport = this.expect("static");
            if (staticImport) {
                this.parseWhitespacesAndComments();
            }
            String reference = this.readUntil(';', false);
            this.file.getImports().add(reference, staticImport);
            this.parseWhitespacesAndComments();
        }
    }

    private void parseTypes() {
        BaseType type;
        while ((type = this.parseType(null)) != null && this.hasNext()) {
        }
    }

    private BaseType parseType(BaseType declaringType) {
        this.consume();
        CodeModifiers modifiers = this.parseModifiers(false);
        CodeTypeCategory category = this.parseCategory();
        return this.parseType(declaringType, modifiers, category);
    }

    private BaseType parseType(BaseType declaringType, CodeModifiers modifiers, CodeTypeCategory category) {
        this.consume();
        String simpleName = this.parseIdentifier();
        if (simpleName == null) {
            return null;
        }
        BaseType type = (BaseType)this.file.getType(simpleName, false);
        if (type == null) {
            type = (BaseType)declaringType.getNestedTypes().getDeclaredOrCreate(simpleName);
        }
        type.setCategory(category);
        type.setModifiers(modifiers);
        if (type.isMutable()) {
            type.setComment(this.getElementComment());
        } else {
            type.setComment(this.getElementComment());
        }
        this.parseTypeVariables((CodeElementWithTypeVariables)type, (BaseElement)type);
        this.docParser.parseDoc((CodeType)type, this.javaDocLines);
        if (!this.annotations.isEmpty()) {
            BaseAnnotations typeAnnotations = type.getAnnotations();
            for (CodeAnnotation annotation : this.annotations) {
                typeAnnotations.add(annotation);
            }
        }
        this.clearConsumeState();
        this.parseExtends(type);
        this.parseImplements(type);
        this.consume();
        if (!this.expectOne('{')) {
            String dummy = this.readUntil('{', true);
            LOG.warn("Garbarge before body in {} for type {}: {}", new Object[]{this.file.getQualifiedName(), simpleName, dummy});
        }
        this.parseTypeBody(type);
        return type;
    }

    private void parseTypeBody(BaseType type) {
        boolean elementFound;
        while (elementFound = this.parseTypeElement(type)) {
        }
        if (!this.expectOne('}')) {
            String dummy = this.readUntil('}', true);
            LOG.warn("Garbage at the end of body in {} for type {}: {}", new Object[]{this.file.getQualifiedName(), type.getSimpleName(), dummy});
        }
    }

    private boolean parseTypeElement(BaseType type) {
        this.consume();
        if (this.peek() == '}') {
            return false;
        }
        CodeModifiers modifiers = this.parseModifiers(type.isInterface());
        CodeTypeCategory category = this.parseCategory();
        if (category != null) {
            this.parseType(type, modifiers, category);
            return true;
        }
        CodeComment memberComment = this.getElementComment();
        this.elementComment = null;
        ArrayList<CodeAnnotation> memberAnnotations = null;
        if (!this.annotations.isEmpty()) {
            memberAnnotations = new ArrayList<CodeAnnotation>(this.annotations);
            this.annotations.clear();
        }
        JavaTypeVariablesFromSource typeVariables = this.parseTypeVariables(null, (BaseElement)type);
        String name = this.parseIdentifier();
        if (name == null) {
            CodeBlockInitializer initializer;
            List<CodeStatement> statements = this.parseBlock();
            if (statements == null) {
                LOG.warn("Invalid member of type {} at {}", (Object)type.getSimpleName(), (Object)this.file.getQualifiedName());
                return false;
            }
            if (modifiers.isStatic()) {
                assert (modifiers.getModifiers().size() == 1);
                initializer = type.getStaticInitializer();
            } else {
                assert (modifiers.getModifiers().size() == 0);
                initializer = type.getNonStaticInitializer();
            }
            if (initializer != null) {
                statements.addAll(initializer.getStatements());
            }
            initializer = new BaseBlockInitializer(type, statements);
            if (modifiers.isStatic()) {
                type.setStaticInitializer(initializer);
            } else {
                type.setNonStaticInitializer(initializer);
            }
            return true;
        }
        BaseConstructor member = null;
        if (name.equals(type.getSimpleName()) && this.expectOne('(')) {
            BaseConstructors constructors = type.getConstructors();
            BaseConstructor constructor = typeVariables == null ? new BaseConstructor(constructors) : new BaseConstructor(constructors, (BaseTypeVariables)typeVariables);
            this.parseWhitespacesAndComments();
            this.parseOperation((BaseOperation)constructor);
            constructors.add((CodeMember)constructor);
            member = constructor;
        } else {
            Object element = type;
            if (typeVariables != null) {
                element = typeVariables;
            }
            BaseGenericType memberType = this.parseGenericType(name, (CodeElementWithTypeVariables)element, true, true, false);
            this.consume();
            name = this.parseIdentifier();
            if (name == null) {
                throw new IllegalStateException();
            }
            this.parseWhitespacesAndComments();
            if (this.expectOne('(')) {
                BaseMethod method = typeVariables == null ? new BaseMethod(type.getMethods(), name) : new BaseMethod(type.getMethods(), name, (BaseTypeVariables)typeVariables);
                type.getMethods().add((CodeMember)method);
                method.getReturns().setType((CodeGenericType)memberType);
                this.parseOperation((BaseOperation)method);
                member = method;
            } else {
                BaseField field = type.getFields().add(name);
                field.setType((CodeGenericType)memberType);
                this.parseWhitespacesAndComments();
                if (this.expectOne('=')) {
                    field.setInitializer(this.parseAssignmentValue());
                }
                if (!this.expectOne(';')) {
                    CodeExpression expression = this.parseAssignmentValue();
                    field.setInitializer(expression);
                    if (!this.expectOne(';')) {
                        LOG.warn("Missing ;");
                    }
                }
                member = field;
            }
        }
        return this.parseTypeElementForMember(modifiers, memberComment, memberAnnotations, (BaseMember)member);
    }

    private boolean parseTypeElementForMember(CodeModifiers modifiers, CodeComment memberComment, List<CodeAnnotation> memberAnnotations, BaseMember member) {
        if (member != null) {
            member.setModifiers(modifiers);
            if (memberComment != null) {
                member.setComment(memberComment);
            }
            if (memberAnnotations != null) {
                for (CodeAnnotation annotation : memberAnnotations) {
                    member.getAnnotations().add(annotation);
                }
            }
            if (!this.javaDocLines.isEmpty()) {
                if (member instanceof CodeOperation) {
                    this.docParser.parseDoc((CodeOperation)member, this.javaDocLines);
                } else {
                    this.docParser.parseDoc((CodeField)member, this.javaDocLines);
                }
                this.javaDocLines.clear();
            }
            return true;
        }
        return false;
    }

    private void parseOperation(BaseOperation operation) {
        this.parseOperationArgs(operation);
        this.parseOperationThrows(operation);
        if (operation instanceof BaseMethod && this.expect("default")) {
            this.requireWhitespace((CodeElement)operation, "default", operation);
            CodeExpression value = this.parseAssignmentValue();
            ((BaseMethod)operation).setDefaultValue(value);
        }
        this.parseOperationBody(operation);
    }

    private void parseOperationArgs(BaseOperation operation) {
        boolean todo;
        BaseParameters parameters = operation.getParameters();
        boolean bl = todo = !this.expectOne(')');
        while (todo) {
            this.parseWhitespacesAndComments();
            BaseGenericType argType = this.parseGenericType((CodeElementWithTypeVariables)operation, true, true, false);
            this.skipWhile(CharFilter.WHITESPACE);
            String name = this.parseIdentifier();
            if (name == null) {
                LOG.warn("Missing parameter name for operation {}", (Object)operation);
            } else {
                CodeParameter parameter = parameters.add(name);
                parameter.setType((CodeGenericType)argType);
            }
            if (!(todo = !this.expectOne(')')) || this.expectOne(',')) continue;
            LOG.warn("Expecting ',' or ')' to terminate signature of operation {} but found '{}' in {}", new Object[]{operation, "" + this.peek(), this.file.getQualifiedName()});
        }
    }

    private void parseOperationThrows(BaseOperation operation) {
        this.parseWhitespacesAndComments();
        if (!this.expect("throws")) {
            return;
        }
        this.requireWhitespace((CodeElement)operation, operation.getName(), operation.getParent().getParent());
        BaseExceptions exceptions = operation.getExceptions();
        boolean todo = true;
        while (todo) {
            this.parseWhitespacesAndComments();
            BaseGenericType exceptionType = this.parseGenericType((CodeElementWithTypeVariables)operation, true, true, false);
            exceptions.add((CodeGenericType)exceptionType);
            this.parseWhitespacesAndComments();
            todo = this.expectOne(',');
        }
    }

    private void parseOperationBody(BaseOperation operation) {
        this.parseWhitespacesAndComments();
        if (this.expectOne(';')) {
            return;
        }
        List<CodeStatement> statements = this.parseBlock();
        if (statements == null) {
            LOG.warn("Expecting ';' or '{' to terminate signature of operation {} but found '{}' in {}", new Object[]{operation, "" + this.peek(), this.file.getQualifiedName()});
            return;
        }
        operation.setBody((CodeBlockBody)new BaseBlockBody((CodeFunction)operation, statements));
    }

    private List<CodeStatement> parseBlock() {
        if (!this.expectOne('{')) {
            return null;
        }
        this.skipWhile(CharFilter.WHITESPACE);
        ArrayList<CodeStatement> statements = new ArrayList<CodeStatement>();
        int braceCount = 1;
        while (braceCount > 0) {
            String statement = this.readLine(true);
            braceCount += JavaSourceCodeReaderHighlevel.countMatches(statement, '{');
            if ((braceCount -= JavaSourceCodeReaderHighlevel.countMatches(statement, '}')) > 0) {
                statements.add((CodeStatement)new BaseTextStatement(statement));
                continue;
            }
            assert (statement.equals("}"));
        }
        return statements;
    }

    private static int countMatches(String str, char c) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(c, index)) != -1) {
            ++count;
            ++index;
        }
        return count;
    }

    private JavaTypeVariablesFromSource parseTypeVariables(CodeElementWithTypeVariables element, BaseElement owner) {
        JavaTypeVariablesFromSource result = null;
        if (this.expectOne('<')) {
            BaseTypeVariables typeVariables;
            if (element == null) {
                result = new JavaTypeVariablesFromSource();
                typeVariables = result;
            } else {
                typeVariables = (BaseTypeVariables)element.getTypeParameters();
            }
            boolean todo = true;
            while (todo) {
                this.consume();
                String identifier = this.parseIdentifier();
                BaseTypeVariable typeVariable = new BaseTypeVariable(typeVariables, identifier);
                CodeComment comment = this.getElementComment();
                if (comment != null) {
                    typeVariable.setComment(comment);
                    this.elementComment = null;
                }
                this.parseWhitespacesAndComments();
                if (result == null) {
                    this.parseBound(typeVariable, element);
                } else {
                    this.parseBound(typeVariable, result);
                }
                typeVariables.add((CodeGenericType)typeVariable);
                todo = !this.expectOne('>');
                if (!todo || this.expectOne(',')) continue;
                LOG.warn("Expecting '>' or ',' to terminate type parameter for {} at {} of {}", new Object[]{identifier, owner, this.file.getQualifiedName()});
            }
        }
        this.parseWhitespacesAndComments();
        return result;
    }

    private void parseTypeParameters(JavaGenericTypeFromSource type, CodeElementWithTypeVariables element, boolean withTypeParams) {
        if (this.expectOne('<')) {
            type.ensureTypeParameters();
            boolean todo = true;
            while (todo) {
                this.parseWhitespacesAndComments();
                BaseGenericType typeParam = this.parseGenericType(element, withTypeParams, true, false);
                type.addTypeParameter(typeParam);
                this.parseWhitespacesAndComments();
                todo = !this.expectOne('>');
                if (!todo || this.expectOne(',')) continue;
                LOG.warn("Expecting '>' or ',' to terminate type parameter for {} at {} of {}", new Object[]{type.getName(), element, this.file.getQualifiedName()});
            }
        }
    }

    private void parseImplements(BaseType type) {
        this.consume();
        boolean found = this.expect("implements");
        if (!found) {
            return;
        }
        if (type.isAnnotation() || type.isInterface()) {
            LOG.warn("Type {} is {} and cannot use implements keyword.", (Object)type, (Object)type.getCategory());
        }
        this.consume();
        this.parseSuperTypes(type);
    }

    private void parseExtends(BaseType type) {
        this.consume();
        boolean found = this.expect("extends");
        if (!found) {
            return;
        }
        if (type.isAnnotation() || type.isEnumeration()) {
            LOG.warn("Type {} is {} and cannot use extends keyword.", (Object)type, (Object)type.getCategory());
        }
        this.consume();
        this.parseSuperTypes(type);
    }

    private void parseSuperTypes(BaseType type) {
        boolean todo = true;
        while (todo) {
            BaseGenericType superType = this.parseGenericType((CodeElementWithTypeVariables)type, true, false, false);
            type.getSuperTypes().add((CodeGenericType)superType);
            this.parseWhitespacesAndComments();
            todo = this.expectOne(',');
            this.parseWhitespacesAndComments();
        }
    }

    private BaseGenericType parseGenericType(CodeElementWithTypeVariables element, boolean withTypeParams, boolean withArray, boolean withComposedTypes) {
        String typeName = this.parseQName();
        if (typeName == null) {
            if (this.expectOne('?')) {
                typeName = "?";
            } else {
                throw new IllegalStateException();
            }
        }
        return this.parseGenericType(typeName, element, withTypeParams, withArray, withComposedTypes);
    }

    private BaseGenericType parseGenericType(String typeName, CodeElementWithTypeVariables element, boolean withTypeParams, boolean withArray, boolean withComposedTypes) {
        boolean found;
        JavaGenericTypeFromSource type = new JavaGenericTypeFromSource(element, typeName, this.file);
        this.parseWhitespacesAndComments();
        this.applyCommentAndAnnotations((BaseElement)type);
        if ("?".equals(typeName) && !(found = this.parseBound(type, false, element, true))) {
            this.parseBound(type, true, element, true);
        }
        if (withTypeParams) {
            this.parseTypeParameters(type, element, withTypeParams);
        }
        if (withComposedTypes) {
            while (this.expectOne('&')) {
                this.parseWhitespacesAndComments();
                BaseGenericType composedType = this.parseGenericType(element, withTypeParams, false, false);
                type.addComposedType(composedType);
            }
        }
        if (withArray) {
            while (this.expectOne('[')) {
                this.parseWhitespacesAndComments();
                if (!this.expectOne(']')) {
                    String text = this.readUntil(']', false);
                    if (text == null) {
                        LOG.error("Unterminated array after {} at {} of {}", new Object[]{typeName, element, this.file.getQualifiedName()});
                        return type;
                    }
                    if (!(text = text.trim()).isEmpty()) {
                        type.setArrayLengthExpression(text);
                    }
                }
                type.incArrayCount();
                this.parseWhitespacesAndComments();
            }
        }
        return type;
    }

    private boolean parseBound(BaseTypeVariable typeVariable, CodeElementWithTypeVariables element) {
        String keyword = "extends";
        if (this.expect(keyword)) {
            String name = typeVariable.getName();
            this.requireWhitespace((CodeElement)element, keyword, name);
            BaseGenericType bound = this.parseGenericType(element, true, true, true);
            if (bound == null) {
                LOG.warn("Missing {} bound after type parameter {} at {} of {}", new Object[]{keyword, name, element, this.file.getQualifiedName()});
                return false;
            }
            typeVariable.setBound((CodeGenericType)bound);
            return true;
        }
        return false;
    }

    private void requireWhitespace(CodeElement element, String keyword, Object context) {
        int count = this.skipWhile(CharFilter.WHITESPACE);
        if (count == 0) {
            LOG.warn("Missing whitespace after '{}'.", (Object)keyword);
        }
    }

    private boolean parseBound(JavaGenericTypeFromSource type, boolean superBound, CodeElementWithTypeVariables element, boolean withComposedTypes) {
        String keyword = superBound ? "super" : "extends";
        if (this.expect(keyword)) {
            BaseGenericType bound;
            int count = this.skipWhile(CharFilter.WHITESPACE);
            if (count == 0) {
                LOG.warn("Missing whitespace after {} expression of type parameter {} at {} of {}", new Object[]{keyword, type.getName(), element, this.file.getQualifiedName()});
            }
            if ((bound = this.parseGenericType(element, true, true, withComposedTypes)) == null) {
                LOG.warn("Missing {} bound after type parameter {} at {} of {}", new Object[]{keyword, type.getName(), element, this.file.getQualifiedName()});
                return false;
            }
            if (superBound) {
                type.setSuperBound(bound);
            } else {
                type.setExtendsBound(bound);
            }
            return true;
        }
        return false;
    }

    private void applyCommentAndAnnotations(BaseElement element) {
        CodeComment comment = this.getElementComment();
        if (comment != null) {
            element.setComment(comment);
            this.elementComment = null;
        }
        if (!this.annotations.isEmpty()) {
            for (CodeAnnotation annotation : this.annotations) {
                element.getAnnotations().add(annotation);
            }
            this.annotations.clear();
        }
    }

    private CodeTypeCategory parseCategory() {
        this.consume();
        char c = this.peek();
        if (c == 'c') {
            if (this.expect("class")) {
                return CodeTypeCategory.CLASS;
            }
        } else if (c == 'i') {
            if (this.expect("interface")) {
                return CodeTypeCategory.INTERFACE;
            }
        } else if (c == 'e') {
            if (this.expect("enum")) {
                return CodeTypeCategory.ENUMERAION;
            }
        } else if (c == '@' && this.expect("@interface")) {
            return CodeTypeCategory.ANNOTATION;
        }
        return null;
    }
}

