/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.api.expression.CodeCondition;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralBoolean
extends JavaLiteral<Boolean>
implements CodeCondition {
    public static final JavaLiteralBoolean TRUE = new JavaLiteralBoolean(Boolean.TRUE);
    public static final JavaLiteralBoolean FALSE = new JavaLiteralBoolean(Boolean.FALSE);

    private JavaLiteralBoolean(Boolean value) {
        super(value);
    }

    @Override
    public String getSourceCode() {
        if (((Boolean)this.getValue()).booleanValue()) {
            return "true";
        }
        return "false";
    }

    @Override
    public JavaLiteral<Boolean> withValue(Boolean newValue) {
        if (newValue.booleanValue()) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public Class<Boolean> getJavaClass() {
        return Boolean.TYPE;
    }

    public static JavaLiteralBoolean of(boolean value) {
        if (value) {
            return TRUE;
        }
        return FALSE;
    }
}

