/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralLong
extends JavaLiteral<Long> {
    public static final JavaLiteralLong VALUE_0 = new JavaLiteralLong(0L);
    public static final JavaLiteralLong VALUE_1 = new JavaLiteralLong(1L);
    public static final JavaLiteralLong VALUE_MIN = new JavaLiteralLong(Long.MIN_VALUE);
    public static final JavaLiteralLong VALUE_MAX = new JavaLiteralLong(Long.MAX_VALUE);

    private JavaLiteralLong(Long value) {
        super(value);
    }

    public JavaLiteralLong withValue(Long newValue) {
        return new JavaLiteralLong(newValue);
    }

    @Override
    public Class<Long> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Long.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Long.MAX_VALUE";
        }
        return ((Long)this.getValue()).toString() + "L";
    }

    public static JavaLiteralLong of(long value) {
        return JavaLiteralLong.of((Long)value);
    }

    public static JavaLiteralLong of(Long value) {
        if (value == 0L) {
            return VALUE_0;
        }
        if (value == 1L) {
            return VALUE_1;
        }
        return new JavaLiteralLong(value);
    }
}

