/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.parser;

import io.github.mmm.base.filter.CharFilter;
import io.github.mmm.base.text.TextFormatMessageType;
import io.github.mmm.code.api.CodeFile;
import io.github.mmm.code.api.CodeName;
import io.github.mmm.code.api.annotation.CodeAnnotation;
import io.github.mmm.code.api.annotation.CodeAnnotations;
import io.github.mmm.code.api.comment.CodeComment;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.imports.CodeImport;
import io.github.mmm.code.api.modifier.CodeModifiers;
import io.github.mmm.code.api.modifier.CodeVisibility;
import io.github.mmm.code.api.operator.CodeNAryOperator;
import io.github.mmm.code.api.operator.CodeOperator;
import io.github.mmm.code.base.BaseFile;
import io.github.mmm.code.base.annoation.BaseAnnotation;
import io.github.mmm.code.base.comment.BaseBlockComment;
import io.github.mmm.code.base.comment.BaseComments;
import io.github.mmm.code.base.comment.BaseSingleLineComment;
import io.github.mmm.code.base.expression.BaseArrayInstatiation;
import io.github.mmm.code.base.expression.BaseFieldReferenceLazy;
import io.github.mmm.code.base.expression.BaseMethodInvocation;
import io.github.mmm.code.base.member.BaseMethod;
import io.github.mmm.code.base.operator.BaseOperator;
import io.github.mmm.code.impl.java.expression.JavaNAryOperatorExpression;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralBoolean;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralChar;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralString;
import io.github.mmm.scanner.CharReaderScanner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaSourceCodeReaderLowlevel
extends CharReaderScanner {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSourceCodeReaderLowlevel.class);
    static final CharFilter CHAR_FILTER_SPACES = c -> c == 32 || c == 9;
    static final CharFilter CHAR_FILTER_IDENTIFIER = c -> Character.isJavaIdentifierPart(c);
    static final CharFilter CHAR_FILTER_QNAME = c -> Character.isJavaIdentifierPart(c) || c == 46;
    static final CharFilter CHAR_FILTER_ANNOTATION_KEY = c -> c == 123 || c == 61 || c == 44;
    static final CharFilter CHAR_FILTER_OPERATOR = c -> c == 43 || c == 45 || c == 42 || c == 47 || c == 94 || c == 37 || c == 62 || c == 60 || c == 33 || c == 126 || c == 61;
    static final CharFilter CHAR_FILTER_NUMBER_LITERAL_START = c -> c >= 48 && c <= 57 || c == 43 || c == 45;
    static final CharFilter CHAR_FILTER_STATEMENT_END = c -> c == 59 || c == 13 || c == 10;
    protected final List<String> javaDocLines = new ArrayList<String>();
    protected final List<CodeComment> comments = new ArrayList<CodeComment>();
    protected CodeComment elementComment;
    protected final List<CodeAnnotation> annotations = new ArrayList<CodeAnnotation>();
    protected BaseFile file;

    public JavaSourceCodeReaderLowlevel() {
        this(4096);
    }

    public JavaSourceCodeReaderLowlevel(int capacity) {
        super(capacity);
    }

    protected void reset() {
        super.reset();
        this.clearConsumeState();
        this.file = null;
    }

    protected void clearConsumeState() {
        this.javaDocLines.clear();
        this.comments.clear();
        this.elementComment = null;
        this.annotations.clear();
    }

    public List<CodeComment> getComments() {
        return this.comments;
    }

    public CodeComment getElementComment() {
        if (this.elementComment == null) {
            int size = this.comments.size();
            if (size == 1) {
                this.elementComment = this.comments.get(0);
            } else if (size > 1) {
                this.elementComment = new BaseComments(new ArrayList<CodeComment>(this.comments));
            }
            this.comments.clear();
        }
        return this.elementComment;
    }

    public List<String> getJavaDocLines() {
        return this.javaDocLines;
    }

    public List<CodeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void consume() {
        this.skipWhile(CharFilter.WHITESPACE);
        int cp = this.peek();
        if (cp == 47) {
            this.next();
            this.parseDocOrComment();
            this.consume();
        } else if (cp == 64) {
            this.next();
            this.getElementComment();
            this.parseAnnotations();
            this.consume();
        }
    }

    protected void parseWhitespacesAndComments() {
        this.skipWhile(CharFilter.WHITESPACE);
        if (this.expectOne(47)) {
            this.parseDocOrComment();
        }
    }

    private CodeComment getAndClearComments() {
        Object comment = null;
        int commentCount = this.comments.size();
        if (commentCount > 0) {
            comment = commentCount == 1 ? this.comments.get(0) : new BaseComments(new ArrayList<CodeComment>(this.comments));
            this.comments.clear();
        }
        return comment;
    }

    protected String parseIdentifier() {
        if (Character.isJavaIdentifierStart(this.peek())) {
            return this.readWhile(CHAR_FILTER_IDENTIFIER);
        }
        return null;
    }

    protected String parseQName() {
        if (Character.isJavaIdentifierStart(this.peek())) {
            return this.readWhile(CHAR_FILTER_QNAME);
        }
        return null;
    }

    private void parseAnnotations() {
        CodeComment comment;
        String annotationTypeName = this.parseQName();
        String annotationQName = this.getQualifiedName(annotationTypeName);
        BaseAnnotation annotation = new BaseAnnotation((CodeAnnotations)this.file.getAnnotations(), annotationTypeName, annotationQName);
        if (this.expectOne(40)) {
            this.parseAnnotationParameters((CodeAnnotation)annotation, annotationTypeName);
        }
        if ((comment = this.getAndClearComments()) != null) {
            annotation.setComment(comment);
        }
        this.annotations.add((CodeAnnotation)annotation);
    }

    private void parseAnnotationParameters(CodeAnnotation annotation, String annotationTypeName) {
        this.parseWhitespacesAndComments();
        if (this.expectOne(41)) {
            return;
        }
        Map parameters = annotation.getParameters();
        boolean first = true;
        while (!this.expectOne(41)) {
            boolean comma;
            if (!first && !(comma = this.expectOne(44))) {
                LOG.warn("Annotation {} parameters not separated with comma in {}.", (Object)annotationTypeName, (Object)this.file);
            }
            CodeExpression value = null;
            String key = this.readUntil(CHAR_FILTER_ANNOTATION_KEY, false, ")", false, true);
            if (key.isEmpty()) {
                if (first) {
                    key = "value";
                } else {
                    LOG.warn("Annotation {} parameter without name (found '{}') in {}.", new Object[]{annotationTypeName, Character.toString(this.peek()), this.file});
                }
            } else {
                this.parseWhitespacesAndComments();
                if (!this.expectOne(61)) {
                    for (CodeImport importStatement : this.file.getImports()) {
                        if (!importStatement.isStatic()) continue;
                        String reference = importStatement.getReference();
                        int index = reference.length() - key.length() - 1;
                        if (!reference.endsWith(key) || index <= 0 || reference.charAt(index) != '.') continue;
                        String fieldName = key;
                        key = "value";
                        String typeName = reference.substring(0, index);
                        value = new BaseFieldReferenceLazy(this.file.getContext(), typeName, null, fieldName);
                        break;
                    }
                    if (value == null) {
                        LOG.warn("Invalid character '{}' after annotation parameter {}.{} name in {}.", new Object[]{Character.toString(this.peek()), annotationTypeName, key, this.file});
                    }
                }
            }
            if (value == null) {
                if (this.expectOne(123)) {
                    CodeExpression arg;
                    ArrayList<CodeExpression> args = new ArrayList<CodeExpression>();
                    do {
                        if ((arg = this.parseAssignmentValue()) == null) continue;
                        args.add(arg);
                    } while (arg != null && this.expectOne(44));
                    if (!this.expectOne(125)) {
                        LOG.warn("Invalid annotation array value - missing closing curly brace '}' for annotation {} at value {}", (Object)annotationTypeName, (Object)key);
                    }
                    value = new BaseArrayInstatiation(args);
                } else {
                    value = this.parseAssignmentValue();
                }
            }
            parameters.put(key, value);
            first = false;
        }
    }

    CodeExpression parseAssignmentValue() {
        this.parseWhitespacesAndComments();
        CodeExpression expression = this.parseSingleAssignmentValue();
        CodeOperator operator = null;
        ArrayList<CodeExpression> expressions = null;
        while (true) {
            this.parseWhitespacesAndComments();
            int cp = this.peek();
            if (!CHAR_FILTER_OPERATOR.accept(cp)) break;
            String operatorName = this.readWhile(CHAR_FILTER_OPERATOR);
            CodeOperator nextOperator = BaseOperator.of((String)operatorName);
            if (operator == null) {
                operator = nextOperator;
                if (expressions == null) {
                    expressions = new ArrayList<CodeExpression>();
                }
                expressions.add(expression);
                continue;
            }
            if (operator == nextOperator) continue;
            if (operator.isNAry()) {
                expression = new JavaNAryOperatorExpression((CodeNAryOperator)operator, new ArrayList<CodeExpression>(expressions));
                Objects.requireNonNull(expressions);
                expressions.clear();
                expressions.add(expression);
            }
            operator = nextOperator;
        }
        return expression;
    }

    private CodeExpression parseSingleAssignmentValue() {
        BaseMethodInvocation expression = this.parseLiteral();
        if (expression != null) {
            return expression;
        }
        String qName = this.parseQName();
        this.parseWhitespacesAndComments();
        if (this.expectOne(40)) {
            CodeName codeName;
            CodeName parent;
            ArrayList<CodeExpression> arguments = new ArrayList<CodeExpression>();
            CodeExpression arg = this.parseSingleAssignmentValue();
            if (arg != null) {
                arguments.add(arg);
                this.parseWhitespacesAndComments();
                while (this.expectOne(44)) {
                    arg = this.parseSingleAssignmentValue();
                    if (arg == null) {
                        LOG.debug("Missing argument after ','");
                        break;
                    }
                    arguments.add(arg);
                    this.parseWhitespacesAndComments();
                }
            }
            if (!this.expectOne(41)) {
                LOG.debug("Missing ')'");
            }
            if ((parent = (codeName = new CodeName(qName, '.')).getParent()) != null) {
                // empty if block
            }
            BaseMethod method = null;
            expression = new BaseMethodInvocation(method, arguments);
        }
        return expression;
    }

    private JavaLiteral<?> parseLiteral() {
        String stringLiteral = this.readJavaStringLiteral(TextFormatMessageType.WARNING);
        if (stringLiteral != null) {
            return JavaLiteralString.of(stringLiteral);
        }
        Boolean booleanLiteral = this.readBoolean();
        if (booleanLiteral != null) {
            return JavaLiteralBoolean.of(booleanLiteral);
        }
        Character charLiteral = this.readJavaCharLiteral(TextFormatMessageType.WARNING);
        if (charLiteral != null) {
            return JavaLiteralChar.of(charLiteral);
        }
        Number numberLiteral = this.readJavaNumberLiteral();
        if (numberLiteral != null) {
            return JavaLiteral.of(numberLiteral);
        }
        return null;
    }

    private String getQualifiedName(String name) {
        if (name.indexOf(46) == -1) {
            return this.file.getContext().getQualifiedName(name, (CodeFile)this.file, false);
        }
        return name;
    }

    private void parseDocOrComment() {
        int cp = this.peek();
        if (cp == 47) {
            String docLine = this.readLine(true);
            this.comments.add((CodeComment)new BaseSingleLineComment(docLine));
        } else if (cp == 42) {
            this.next();
            cp = this.peek();
            if (cp == 42) {
                this.next();
                if (!this.javaDocLines.isEmpty()) {
                    LOG.warn("Duplicate JavaDoc in {}.", (Object)this.file);
                }
                this.parseDocOrBlockComment(this.javaDocLines);
            } else {
                ArrayList<String> lines = new ArrayList<String>();
                this.parseDocOrBlockComment(lines);
                BaseBlockComment comment = new BaseBlockComment(lines);
                this.comments.add((CodeComment)comment);
            }
        } else {
            LOG.warn("Illegal language: {} in {}.", (Object)("/" + cp), (Object)this.file);
        }
    }

    private void parseDocOrBlockComment(List<String> lines) {
        String docLine = this.readDocOrCommentLine();
        if (!docLine.isEmpty()) {
            lines.add(docLine);
        }
        if (this.expect("*/")) {
            return;
        }
        while (true) {
            this.skipWhile(CharFilter.WHITESPACE);
            int cp = this.peek();
            if (cp == 42) {
                this.next();
                cp = this.peek();
                if (cp == 47) {
                    this.next();
                    this.skipWhile(CharFilter.WHITESPACE);
                    return;
                }
            }
            docLine = this.readDocOrCommentLine();
            lines.add(docLine);
        }
    }

    private String readDocOrCommentLine() {
        int max;
        int end;
        this.expectOne(32);
        String docLine = this.readUntil(CharFilter.NEWLINE, true, "*/", false, false);
        for (end = max = docLine.length() - 1; end > 0 && docLine.charAt(end) == ' '; --end) {
        }
        if (end < max) {
            docLine = docLine.substring(0, end + 1);
        }
        return docLine;
    }

    protected CodeModifiers parseModifiers(boolean inInterface) {
        CodeVisibility visibility = this.parseVisibility(null);
        HashSet<String> modifiers = new HashSet<String>();
        boolean found = true;
        while (found) {
            this.skipWhile(CharFilter.WHITESPACE);
            int cp = this.peek();
            if (cp == 97) {
                found = this.parseModifierKeyword(modifiers, "abstract");
            } else if (cp == 100) {
                found = this.parseModifierKeyword(modifiers, "default");
            } else if (cp == 110) {
                found = this.parseModifierKeyword(modifiers, "native");
            } else if (cp == 102) {
                found = this.parseModifierKeyword(modifiers, "final");
            } else if (cp == 118) {
                found = this.parseModifierKeyword(modifiers, "volatile");
            } else if (cp == 115) {
                found = this.parseModifierKeyword(modifiers, "static");
                if (!found && !(found = this.parseModifierKeyword(modifiers, "synchronized"))) {
                    found = this.parseModifierKeyword(modifiers, "synchronized");
                }
            } else {
                found = cp == 116 ? this.parseModifierKeyword(modifiers, "transient") : false;
            }
            if (visibility != null) continue;
            visibility = this.parseVisibility(null);
            if (found) continue;
            found = visibility != null;
        }
        if (visibility == null) {
            visibility = this.getVisibilityFallback(inInterface);
        }
        return new CodeModifiers(visibility, modifiers);
    }

    private boolean parseModifierKeyword(Set<String> modifiers, String modifier) {
        if (this.expect(modifier)) {
            modifiers.add(modifier);
            return true;
        }
        return false;
    }

    private CodeVisibility getVisibilityFallback(boolean inInterface) {
        if (inInterface) {
            return CodeVisibility.PUBLIC;
        }
        return CodeVisibility.DEFAULT;
    }

    private CodeVisibility parseVisibility(CodeVisibility fallback) {
        if (this.peek() != 112) {
            return fallback;
        }
        if (this.expect("private")) {
            return CodeVisibility.PRIVATE;
        }
        if (this.expect("public")) {
            return CodeVisibility.PUBLIC;
        }
        if (this.expect("protected")) {
            return CodeVisibility.PROTECTED;
        }
        return fallback;
    }
}

