/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralByte
extends JavaLiteral<Byte> {
    public static final JavaLiteralByte VALUE_0 = new JavaLiteralByte((byte)0);
    public static final JavaLiteralByte VALUE_1 = new JavaLiteralByte((byte)1);
    public static final JavaLiteralByte VALUE_MIN = new JavaLiteralByte((byte)-128);
    public static final JavaLiteralByte VALUE_MAX = new JavaLiteralByte((byte)127);

    private JavaLiteralByte(Byte value) {
        super(value);
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Byte.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Byte.MAX_VALUE";
        }
        return ((Byte)this.getValue()).toString();
    }

    public JavaLiteralByte withValue(Byte newValue) {
        return new JavaLiteralByte(newValue);
    }

    @Override
    public Class<Byte> getJavaClass() {
        return Byte.TYPE;
    }

    public static JavaLiteralByte of(byte value) {
        return JavaLiteralByte.of((Byte)value);
    }

    public static JavaLiteralByte of(Byte value) {
        if (value == 0) {
            return VALUE_0;
        }
        if (value == 1) {
            return VALUE_1;
        }
        return new JavaLiteralByte(value);
    }
}

