/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralInt
extends JavaLiteral<Integer> {
    public static final JavaLiteralInt VALUE_0 = new JavaLiteralInt(0);
    public static final JavaLiteralInt VALUE_1 = new JavaLiteralInt(1);
    public static final JavaLiteralInt VALUE_MIN = new JavaLiteralInt(Integer.MIN_VALUE);
    public static final JavaLiteralInt VALUE_MAX = new JavaLiteralInt(Integer.MAX_VALUE);

    private JavaLiteralInt(Integer value) {
        super(value);
    }

    public JavaLiteralInt withValue(Integer newValue) {
        return new JavaLiteralInt(newValue);
    }

    @Override
    public Class<Integer> getJavaClass() {
        return Integer.TYPE;
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Integer.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Integer.MAX_VALUE";
        }
        return ((Integer)this.getValue()).toString();
    }

    public static JavaLiteralInt of(int value) {
        return JavaLiteralInt.of((Integer)value);
    }

    public static JavaLiteralInt of(Integer value) {
        if (value == 0) {
            return VALUE_0;
        }
        if (value == 1) {
            return VALUE_1;
        }
        return new JavaLiteralInt(value);
    }
}

