/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.source.maven;

import io.github.mmm.code.api.source.CodeSourceDescriptor;
import io.github.mmm.code.base.BaseContext;
import io.github.mmm.code.base.loader.BaseSourceLoader;
import io.github.mmm.code.base.source.BaseSource;
import io.github.mmm.code.base.source.BaseSourceDependencies;
import io.github.mmm.code.base.source.BaseSourceDescriptorType;
import io.github.mmm.code.base.source.BaseSourceImpl;
import io.github.mmm.code.impl.java.source.maven.JavaSourceProviderUsingMaven;
import io.github.mmm.code.java.maven.api.MavenConstants;
import io.github.mmm.code.java.maven.api.ModelHelper;
import java.io.File;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;

public class JavaSourceUsingMaven
extends BaseSourceImpl
implements MavenConstants {
    private final JavaSourceProviderUsingMaven sourceProvider;
    private BaseSource compileDependency;
    private Supplier<Model> modelSupplier;
    private Model model;
    private String scope;

    public JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, CodeSource reflectiveObject, Supplier<Model> modelSupplier, BaseSourceLoader sourceLoader) {
        this(sourceProvider, reflectiveObject, null, null, null, modelSupplier, null, null, null, sourceLoader, true);
    }

    public JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, BaseSource compileDependency, File byteCodeLocation, File sourceCodeLocation, Supplier<Model> modelSupplier, BaseSourceLoader sourceLoader) {
        this(sourceProvider, null, byteCodeLocation, sourceCodeLocation, null, modelSupplier, compileDependency, null, "test", sourceLoader, true);
    }

    public JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, File byteCodeLocation, File sourceCodeLocation, Supplier<Model> modelSupplier, String scope, BaseSourceLoader sourceLoader) {
        this(sourceProvider, null, byteCodeLocation, sourceCodeLocation, null, modelSupplier, null, null, scope, sourceLoader, true);
    }

    public JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, CodeSource reflectiveObject, File byteCodeLocation, File sourceCodeLocation, Supplier<Model> modelSupplier, String scope, BaseSourceLoader sourceLoader) {
        this(sourceProvider, reflectiveObject, byteCodeLocation, sourceCodeLocation, null, modelSupplier, null, null, scope, sourceLoader, true);
    }

    public JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, String id, JavaSourceUsingMaven compileDependency, JavaSourceUsingMaven testDependency, Supplier<Model> modelSupplier, BaseSourceLoader sourceLoader, boolean immutable) {
        this(sourceProvider, null, null, null, id, modelSupplier, null, Arrays.asList(new BaseSource[]{compileDependency, testDependency}), null, sourceLoader, immutable);
    }

    private JavaSourceUsingMaven(JavaSourceProviderUsingMaven sourceProvider, CodeSource reflectiveObject, File byteCodeLocation, File sourceCodeLocation, String id, Supplier<Model> modelSupplier, BaseSource compileDependency, List<BaseSource> dependencies, String scope, BaseSourceLoader sourceLoader, boolean immutable) {
        super(reflectiveObject, byteCodeLocation, sourceCodeLocation, id, null, dependencies, sourceLoader, immutable);
        this.sourceProvider = sourceProvider;
        this.modelSupplier = modelSupplier;
        this.compileDependency = compileDependency;
        this.scope = scope;
    }

    public BaseContext getContext() {
        BaseContext context = super.getContext();
        if (context == null) {
            context = this.sourceProvider.getContext();
            this.setContext(context);
        }
        return context;
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = this.modelSupplier.get();
            Objects.requireNonNull(this.model, "model");
            this.modelSupplier = null;
        }
        return this.model;
    }

    public String getScope() {
        return this.scope;
    }

    protected CodeSourceDescriptor createDescriptor() {
        Model mavenModel = this.getModel();
        String javadocUrl = null;
        return new BaseSourceDescriptorType(mavenModel.getGroupId(), mavenModel.getArtifactId(), mavenModel.getVersion(), this.scope, javadocUrl);
    }

    protected BaseSourceDependencies createDependencies() {
        return new BaseSourceDependencies((BaseSource)this, this::getDependencyList);
    }

    protected File createSourceCodeLocation() {
        String extension;
        String basename;
        File sourceCodeLocation;
        File byteCodeLocation = this.getByteCodeLocation();
        if (byteCodeLocation == null) {
            return null;
        }
        String filename = byteCodeLocation.getName();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot == filename.length() - 4 && (sourceCodeLocation = new File((basename = filename.substring(0, lastDot)) + "-sources" + (extension = filename.substring(lastDot)))).exists()) {
            return sourceCodeLocation;
        }
        if (byteCodeLocation.isDirectory()) {
            return ModelHelper.getSourceDirectory((Model)this.getModel());
        }
        return null;
    }

    private List<BaseSource> getDependencyList() {
        List dependencies = this.getModel().getDependencies();
        ArrayList<BaseSource> sourceDependencies = new ArrayList<BaseSource>(dependencies.size());
        if (this.compileDependency != null) {
            sourceDependencies.add(this.compileDependency);
        }
        boolean isTestScope = "test".equals(this.scope);
        for (Dependency dependency : dependencies) {
            boolean isTestDependency = "test".equals(dependency.getScope());
            if (isTestDependency != isTestScope) continue;
            BaseSource source = this.sourceProvider.createSource(dependency);
            sourceDependencies.add(source);
        }
        return sourceDependencies;
    }
}

