/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.operator;

import io.github.mmm.code.api.operator.CodeNAryOperator;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateNumeric;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateString;

abstract class JavaNAryOperatorAggregate<T> {
    protected final CodeNAryOperator operator;

    public JavaNAryOperatorAggregate(CodeNAryOperator operator) {
        this.operator = operator;
    }

    public abstract T getValue();

    public JavaNAryOperatorAggregate<?> evaluate(Object arg) {
        boolean bool;
        String operatorName = this.operator.getName();
        if (arg == null) {
            if ("+".equals(operatorName)) {
                return this.add("null");
            }
            return null;
        }
        boolean numeric = this.operator.isNumeric();
        if (numeric != (bool = this.operator.isBoolean()) && (numeric ? !(arg instanceof Number) : !(arg instanceof Boolean))) {
            return null;
        }
        switch (operatorName) {
            case "+": {
                return this.add(arg);
            }
            case "&&": {
                return this.and((Boolean)arg);
            }
            case "&": {
                if (arg instanceof Boolean) {
                    return this.and((Boolean)arg);
                }
                return this.bitAnd((Number)arg);
            }
            case "|": {
                if (arg instanceof Boolean) {
                    return this.or((Boolean)arg);
                }
                return this.bitOr((Number)arg);
            }
            case "/": {
                return this.div((Number)arg);
            }
            case "%": {
                return this.mod((Number)arg);
            }
            case "*": {
                return this.mul((Number)arg);
            }
            case "||": {
                return this.or((Boolean)arg);
            }
            case "<<": {
                return this.shiftLeft((Number)arg);
            }
            case ">>": {
                return this.shiftRightSigned((Number)arg);
            }
            case ">>>": {
                return this.shiftRightUnsigned((Number)arg);
            }
            case "-": {
                return this.sub((Number)arg);
            }
            case "^": {
                if (arg instanceof Boolean) {
                    return this.xor((Boolean)arg);
                }
                return this.xor((Number)arg);
            }
        }
        throw new IllegalStateException(operatorName);
    }

    protected JavaNAryOperatorAggregate<?> add(Object arg) {
        if (arg instanceof Number) {
            return this.add((Number)arg);
        }
        return this.add(arg.toString());
    }

    protected JavaNAryOperatorAggregateString add(String arg) {
        return new JavaNAryOperatorAggregateString(this.operator, this.getValue().toString()).add(arg);
    }

    protected JavaNAryOperatorAggregate<?> add(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregate<? extends Boolean> or(Boolean arg) {
        return null;
    }

    protected JavaNAryOperatorAggregate<? extends Boolean> and(Boolean arg) {
        return null;
    }

    protected JavaNAryOperatorAggregate<? extends Boolean> xor(Boolean arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> sub(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> mul(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> div(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> mod(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> shiftLeft(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> shiftRightUnsigned(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> shiftRightSigned(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> xor(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> bitOr(Number arg) {
        return null;
    }

    protected JavaNAryOperatorAggregateNumeric<?> bitAnd(Number arg) {
        return null;
    }
}

