/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.source.maven;

import io.github.mmm.code.base.loader.BaseSourceCodeProviderArchive;
import io.github.mmm.code.base.loader.BaseSourceCodeProviderDirectory;
import io.github.mmm.code.base.loader.BaseSourceLoader;
import io.github.mmm.code.base.loader.SourceCodeProvider;
import io.github.mmm.code.base.loader.SourceCodeProviderProxy;
import io.github.mmm.code.base.source.BaseSource;
import io.github.mmm.code.base.source.BaseSourceHelper;
import io.github.mmm.code.base.source.BaseSourceImpl;
import io.github.mmm.code.base.source.BaseSourceProvider;
import io.github.mmm.code.base.source.BaseSourceProviderImpl;
import io.github.mmm.code.impl.java.JavaContext;
import io.github.mmm.code.impl.java.JavaExtendedContext;
import io.github.mmm.code.impl.java.JavaRootContext;
import io.github.mmm.code.impl.java.loader.JavaSourceLoader;
import io.github.mmm.code.impl.java.source.maven.JavaSourceUsingMaven;
import io.github.mmm.code.impl.java.source.maven.MavenDependencyCollector;
import io.github.mmm.code.impl.java.supplier.SupplierAdapter;
import io.github.mmm.code.java.maven.api.DependencyHelper;
import io.github.mmm.code.java.maven.api.MavenBridge;
import io.github.mmm.code.java.maven.api.MavenConstants;
import io.github.mmm.code.java.maven.api.ModelHelper;
import io.github.mmm.code.java.maven.impl.MavenBridgeImpl;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceProviderUsingMaven
extends BaseSourceProviderImpl
implements MavenConstants {
    private final MavenBridge mavenBridge;
    private static final Logger LOG = LoggerFactory.getLogger(JavaSourceProviderUsingMaven.class);

    public JavaSourceProviderUsingMaven() {
        this(MavenBridgeImpl.getDefault());
    }

    public JavaSourceProviderUsingMaven(MavenBridge mavenBridge) {
        this.mavenBridge = mavenBridge;
    }

    public BaseSource create(CodeSource source) {
        Objects.requireNonNull(source, "source");
        File location = BaseSourceHelper.asFile((URL)source.getLocation());
        Supplier<Model> supplier = this.createModelSupplier(location);
        SourceCodeProviderProxy sourceCodeProvider = new SourceCodeProviderProxy(() -> this.createSourceCodeProvider(location, supplier));
        JavaSourceLoader loader = new JavaSourceLoader((SourceCodeProvider)sourceCodeProvider);
        return new JavaSourceUsingMaven(this, source, supplier, (BaseSourceLoader)loader);
    }

    private SourceCodeProvider createSourceCodeProvider(File location, Supplier<Model> supplier) {
        Model model;
        File artifactSources = this.mavenBridge.findArtifactSources(location);
        if (artifactSources != null) {
            return new BaseSourceCodeProviderArchive(artifactSources);
        }
        if (location.isDirectory() && (model = supplier.get()) != null) {
            return new BaseSourceCodeProviderDirectory(ModelHelper.getSourceDirectory((Model)model));
        }
        return null;
    }

    public BaseSource create(File byteCodeLocation, File sourceCodeLocation) {
        File location = byteCodeLocation != null ? byteCodeLocation : sourceCodeLocation;
        Supplier<Model> modelSupplier = this.createModelSupplier(location);
        return new JavaSourceUsingMaven(this, byteCodeLocation, sourceCodeLocation, modelSupplier, null, JavaSourceProviderUsingMaven.createLoader(sourceCodeLocation));
    }

    private Supplier<Model> createModelSupplier(File location) {
        return new SupplierAdapter<Supplier<Model>>(() -> this.mavenBridge.readEffectiveModelFromLocationWithFallback(location));
    }

    private static BaseSourceLoader createLoader(File sourceCodeLocation) {
        Object sourceCodeProvider = sourceCodeLocation == null || !sourceCodeLocation.exists() ? null : (sourceCodeLocation.isDirectory() ? new BaseSourceCodeProviderDirectory(sourceCodeLocation) : new BaseSourceCodeProviderArchive(sourceCodeLocation));
        return new JavaSourceLoader((SourceCodeProvider)sourceCodeProvider);
    }

    BaseSource createSource(Dependency dependency) {
        File byteCodeArtifact = this.mavenBridge.findArtifact(dependency);
        JavaContext context = (JavaContext)this.getContext();
        String id = BaseSourceImpl.getNormalizedId((File)byteCodeArtifact);
        return context.getOrCreateSource(id, () -> this.createSource(dependency, byteCodeArtifact));
    }

    private BaseSource createSource(Dependency dependency, File byteCodeArtifact) {
        File sourceCodeArtifact = null;
        Dependency sourceDependency = DependencyHelper.createSource((Dependency)dependency);
        if (sourceDependency != null) {
            sourceCodeArtifact = this.mavenBridge.findArtifact(sourceDependency);
            sourceCodeArtifact = BaseSourceHelper.getFileOrNull((File)sourceCodeArtifact);
        }
        BaseSourceLoader loader = JavaSourceProviderUsingMaven.createLoader(sourceCodeArtifact);
        try {
            URL reflectiveObjectURL = byteCodeArtifact.toURI().toURL();
            CodeSource dependencyCodeSource = new CodeSource(reflectiveObjectURL, (Certificate[])null);
            return new JavaSourceUsingMaven(this, dependencyCodeSource, byteCodeArtifact, sourceCodeArtifact, () -> this.mavenBridge.readEffectiveModelFromLocationWithFallback(byteCodeArtifact), dependency.getScope(), loader);
        }
        catch (MalformedURLException e) {
            LOG.error("Malformed URL of the byte code artifact");
            return new JavaSourceUsingMaven(this, byteCodeArtifact, sourceCodeArtifact, () -> this.mavenBridge.readEffectiveModelFromLocationWithFallback(byteCodeArtifact), dependency.getScope(), loader);
        }
    }

    private JavaSourceUsingMaven createFromLocalMavenProject(JavaContext parentContext, File location) {
        Model model = this.mavenBridge.readEffectiveModelFromLocation(location, false);
        if (model == null) {
            throw new IllegalArgumentException("Could not find pom.xml for basedir: " + String.valueOf(location));
        }
        Supplier<Model> modelSupplier = () -> model;
        File byteCodeLocation = ModelHelper.getOutputDirectory((Model)model);
        File sourceCodeLocation = ModelHelper.getSourceDirectory((Model)model);
        JavaSourceUsingMaven compileDependency = new JavaSourceUsingMaven(this, byteCodeLocation, sourceCodeLocation, modelSupplier, "compile", JavaSourceProviderUsingMaven.createLoader(sourceCodeLocation));
        File testByteCodeLocation = ModelHelper.getTestOutputDirectory((Model)model);
        File testSourceCodeLocation = ModelHelper.getTestSourceDirectory((Model)model);
        BaseSourceLoader testLoader = JavaSourceProviderUsingMaven.createLoader(testSourceCodeLocation);
        JavaSourceUsingMaven testDependency = new JavaSourceUsingMaven(this, (BaseSource)compileDependency, testByteCodeLocation, testSourceCodeLocation, modelSupplier, testLoader);
        return testDependency;
    }

    public static JavaContext createFromLocalMavenProject() {
        return JavaSourceProviderUsingMaven.createFromLocalMavenProject(JavaSourceProviderUsingMaven.getCwd(), false);
    }

    public static JavaContext createFromLocalMavenProject(File location) {
        return JavaSourceProviderUsingMaven.createFromLocalMavenProject(location, false);
    }

    public static JavaContext createFromLocalMavenProject(File location, boolean buildClassLoader) {
        MavenDependencyCollector dependencyCollector = null;
        if (buildClassLoader) {
            dependencyCollector = new MavenDependencyCollector(true, true, null);
        }
        return JavaSourceProviderUsingMaven.createFromLocalMavenProject(location, dependencyCollector);
    }

    public static JavaContext createFromLocalMavenProject(File location, MavenDependencyCollector dependencyCollector) {
        ClassLoader classLoader;
        JavaSourceProviderUsingMaven provider = dependencyCollector == null ? new JavaSourceProviderUsingMaven() : new JavaSourceProviderUsingMaven(dependencyCollector.mavenBridge);
        JavaSourceUsingMaven source = provider.createFromLocalMavenProject(JavaRootContext.get(), MavenDependencyCollector.normalize(location));
        if (dependencyCollector == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        } else {
            dependencyCollector.collect(source.getModel());
            classLoader = dependencyCollector.asClassLoader();
        }
        return new JavaExtendedContext(source, (BaseSourceProvider)provider, classLoader);
    }

    private static File getCwd() {
        return new File(".").getAbsoluteFile().getParentFile();
    }
}

