/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression;

import io.github.mmm.base.compare.CompareOperator;
import io.github.mmm.code.api.expression.CodeConstant;
import io.github.mmm.code.api.expression.CodeExpression;
import io.github.mmm.code.api.operator.CodeComparisonOperator;
import io.github.mmm.code.base.expression.BaseComparisonOperatorExpression;
import io.github.mmm.code.impl.java.expression.JavaExpression;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralBoolean;

public class JavaComparisonOperatorExpression
extends BaseComparisonOperatorExpression
implements JavaExpression {
    public JavaComparisonOperatorExpression(CodeExpression leftArg, CodeComparisonOperator operator, CodeExpression rightArg) {
        super(leftArg, operator, rightArg);
    }

    @Override
    public JavaLiteral<?> evaluate() {
        CompareOperator op = CompareOperator.ofSymbol((String)this.getOperator().getName());
        if (op == null) {
            return null;
        }
        CodeConstant left = this.getLeftArg().evaluate();
        if (left == null) {
            return null;
        }
        Object leftVal = left.getValue();
        if (leftVal == null) {
            return null;
        }
        CodeConstant right = this.getRightArg().evaluate();
        if (right == null) {
            return null;
        }
        Object rightVal = right.getValue();
        if (rightVal == null) {
            return null;
        }
        boolean result = op.evalObject(leftVal, rightVal);
        return JavaLiteralBoolean.of(result);
    }
}

