/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.constant;

import io.github.mmm.code.api.expression.CodeConstant;
import io.github.mmm.code.api.language.CodeLanguage;
import io.github.mmm.code.base.expression.BaseExpression;
import io.github.mmm.code.impl.java.expression.JavaExpression;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantBoolean;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantByte;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantCharacter;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantDouble;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantFloat;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantInteger;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantLong;
import io.github.mmm.code.impl.java.expression.constant.JavaConstantShort;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralClass;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralEnum;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralNull;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralString;
import java.io.IOException;

public abstract class JavaConstant<T>
extends BaseExpression
implements CodeConstant,
JavaExpression {
    protected final T value;

    public JavaConstant(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public Class<? extends T> getJavaClass() {
        return this.value.getClass();
    }

    public boolean isPrimitive() {
        return false;
    }

    @Override
    public JavaConstant<T> evaluate() {
        return this;
    }

    public abstract String getSourceCode();

    protected void doWrite(Appendable sink, String newline, String defaultIndent, String currentIndent, CodeLanguage language) throws IOException {
        sink.append(this.getSourceCode());
    }

    public abstract JavaConstant<T> withValue(T var1);

    public static JavaConstant<?> of(Object value, boolean primitive) {
        return JavaConstant.of(value, primitive, false);
    }

    public static JavaConstant<?> of(Object value, boolean primitive, boolean qualified) {
        if (value == null) {
            assert (!primitive);
            return JavaLiteralNull.NULL;
        }
        if (primitive) {
            return JavaLiteral.of(value);
        }
        if (value instanceof String) {
            return JavaLiteralString.of((String)value);
        }
        if (value instanceof Class) {
            return JavaLiteralClass.of((Class)value, qualified);
        }
        if (value instanceof Enum) {
            return JavaLiteralEnum.of((Enum)value, qualified);
        }
        if (value instanceof Boolean) {
            return JavaConstantBoolean.of((Boolean)value);
        }
        if (value instanceof Character) {
            return JavaConstantCharacter.of((Character)value);
        }
        if (value instanceof Integer) {
            return JavaConstantInteger.of((Integer)value);
        }
        if (value instanceof Long) {
            return JavaConstantLong.of((Long)value);
        }
        if (value instanceof Double) {
            return JavaConstantDouble.of((Double)value);
        }
        if (value instanceof Float) {
            return JavaConstantFloat.of((Float)value);
        }
        if (value instanceof Short) {
            return JavaConstantShort.of((Short)value);
        }
        if (value instanceof Byte) {
            return JavaConstantByte.of((Byte)value);
        }
        return null;
    }
}

