/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralFloat
extends JavaLiteral<Float> {
    public static final JavaLiteralFloat VALUE_0 = new JavaLiteralFloat(Float.valueOf(0.0f));
    public static final JavaLiteralFloat VALUE_1 = new JavaLiteralFloat(Float.valueOf(1.0f));
    public static final JavaLiteralFloat VALUE_MIN = new JavaLiteralFloat(Float.valueOf(Float.MIN_VALUE));
    public static final JavaLiteralFloat VALUE_MAX = new JavaLiteralFloat(Float.valueOf(Float.MAX_VALUE));

    private JavaLiteralFloat(Float value) {
        super(value);
    }

    public JavaLiteralFloat withValue(Float newValue) {
        return new JavaLiteralFloat(newValue);
    }

    @Override
    public Class<Float> getJavaClass() {
        return Float.TYPE;
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Float.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Float.MAX_VALUE";
        }
        return ((Float)this.getValue()).toString() + "F";
    }

    public static JavaLiteralFloat of(float value) {
        return JavaLiteralFloat.of(Float.valueOf(value));
    }

    public static JavaLiteralFloat of(Float value) {
        if (value.floatValue() == 0.0f) {
            return VALUE_0;
        }
        if (value.floatValue() == 1.0f) {
            return VALUE_1;
        }
        return new JavaLiteralFloat(value);
    }
}

