/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.source.maven;

import io.github.mmm.code.impl.java.source.maven.MavenClassLoader;
import io.github.mmm.code.java.maven.api.DependencyHelper;
import io.github.mmm.code.java.maven.api.MavenBridge;
import io.github.mmm.code.java.maven.api.ModelHelper;
import io.github.mmm.code.java.maven.impl.MavenBridgeImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenDependencyCollector {
    private static final Logger LOG = LoggerFactory.getLogger(MavenDependencyCollector.class);
    final MavenBridge mavenBridge;
    private final List<URL> dependencyList;
    private final Set<URL> dependencySet;
    private final Map<String, Model> gav2ProjectMap;
    private final Map<String, Model> dir2ProjectMap;
    private final boolean buildReactor;
    private final boolean includeTestDependencies;
    private final String altBuildDir;

    public MavenDependencyCollector(boolean includeTestDependencies, boolean buildReactor, String altBuildDir) {
        this(MavenBridgeImpl.getDefault(), includeTestDependencies, buildReactor, altBuildDir);
    }

    public MavenDependencyCollector(MavenBridge mavenBridge, boolean includeTestDependencies, boolean buildReactor, String altBuildDir) {
        this.mavenBridge = mavenBridge;
        this.dependencyList = new ArrayList<URL>();
        this.dependencySet = new HashSet<URL>();
        this.buildReactor = buildReactor;
        if (buildReactor) {
            this.gav2ProjectMap = new HashMap<String, Model>();
            this.dir2ProjectMap = new HashMap<String, Model>();
        } else {
            this.gav2ProjectMap = null;
            this.dir2ProjectMap = null;
        }
        this.includeTestDependencies = includeTestDependencies;
        this.altBuildDir = altBuildDir;
    }

    private boolean add(File dependencyFile, String source) {
        if (!dependencyFile.exists()) {
            LOG.debug("Omitting dependency due to missing file {} for source {}", (Object)dependencyFile, (Object)source);
            return false;
        }
        try {
            return this.add(dependencyFile.toURI().toURL(), source);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Failed to convert file to URL: " + dependencyFile, e);
        }
    }

    private boolean add(URL dependencyUrl, String source) {
        boolean added = this.dependencySet.add(dependencyUrl);
        if (added) {
            if (source == null) {
                LOG.debug("Adding dependency {}", (Object)dependencyUrl);
            } else {
                LOG.debug("Adding dependency {} for {}", (Object)dependencyUrl, (Object)source);
            }
            this.dependencyList.add(dependencyUrl);
        } else {
            LOG.trace("Omitting duplicate dependency {} that was already been collected for source {}.", (Object)dependencyUrl, (Object)source);
        }
        return added;
    }

    public URL[] asUrls() {
        URL[] dependencies = new URL[this.dependencyList.size()];
        return this.dependencyList.toArray(dependencies);
    }

    public ClassLoader asClassLoader() {
        return this.asClassLoader(ClassLoader.getSystemClassLoader().getParent());
    }

    public ClassLoader asClassLoader(ClassLoader parent) {
        return new MavenClassLoader(parent, this.asUrls());
    }

    private Model parseModel(File location) {
        File pomFile = this.mavenBridge.findPom(location);
        if (pomFile == null || !pomFile.isFile()) {
            return null;
        }
        return this.mavenBridge.readEffectiveModel(pomFile);
    }

    private void collectWithReactor(Model model, boolean addDependencies) {
        Parent parent;
        File modelBasedir;
        if (model == null) {
            return;
        }
        String gav = ModelHelper.getGav((Model)model);
        Model duplicate = this.gav2ProjectMap.put(gav, model);
        if (duplicate != null) {
            LOG.warn("Duplicate reactor project for GAV " + gav + ": " + duplicate + " replaced with " + model);
        }
        if ((duplicate = this.dir2ProjectMap.put((modelBasedir = MavenDependencyCollector.normalize(model.getPomFile().getParentFile())).getPath(), model)) != null) {
            LOG.warn("Duplicate reactor project for basedir " + modelBasedir + ": " + duplicate + " replaced with " + model);
        }
        if ((parent = model.getParent()) != null) {
            String parentGav = ModelHelper.getGav((Parent)parent);
            if (this.gav2ProjectMap.containsKey(parentGav)) {
                LOG.trace("Already visited parent project {}", (Object)parentGav);
            } else {
                String parentModelGav;
                File parentPom;
                String relativePath = parent.getRelativePath();
                Model parentModel = null;
                if (!relativePath.isEmpty() && (parentModel = this.parseModel(parentPom = MavenDependencyCollector.normalize(new File(modelBasedir, relativePath)))) != null && !parentGav.equals(parentModelGav = ModelHelper.getGav((Model)parentModel))) {
                    LOG.warn("Project {} has parent {} with relativePath {} but that points to {}", new Object[]{gav, parentGav, relativePath, parentModelGav});
                    parentModel = null;
                }
                if (parentModel == null) {
                    parentPom = MavenDependencyCollector.normalize(this.mavenBridge.findPom(DependencyHelper.create((Parent)parent)));
                    parentModel = this.parseModel(parentPom);
                }
                this.collectWithReactor(parentModel, addDependencies);
            }
        }
        for (String module : model.getModules()) {
            String modulePath;
            File moduleLocation;
            File moduleBasedir = moduleLocation = MavenDependencyCollector.normalize(new File(modelBasedir, module));
            if (moduleLocation.isFile()) {
                moduleBasedir = moduleLocation.getParentFile();
            }
            if (this.dir2ProjectMap.containsKey(modulePath = moduleBasedir.getPath())) {
                LOG.debug("Already visited module project {}", (Object)modulePath);
                continue;
            }
            Model moduleModel = this.parseModel(moduleLocation);
            this.collectWithReactor(moduleModel, false);
        }
        if (addDependencies) {
            LOG.debug("Collecting dependencies for {}", (Object)gav);
            this.addOutputDirectories(model);
            this.collect(model, gav, this.includeTestDependencies, 0);
        }
    }

    public void collect(Model model) {
        if (this.buildReactor) {
            this.collectWithReactor(model, true);
        } else {
            this.addOutputDirectories(model);
            this.collect(model, ModelHelper.getGav((Model)model), this.includeTestDependencies, 0);
        }
    }

    private void addOutputDirectories(Model model) {
        File outputDirectory = ModelHelper.getOutputDirectory((Model)model);
        this.addOutputDirectory(outputDirectory, "classes");
        if (this.includeTestDependencies) {
            File testOutputDirectory = ModelHelper.getTestOutputDirectory((Model)model);
            this.addOutputDirectory(testOutputDirectory, "test-classes");
        }
    }

    private void addOutputDirectory(File outputDirectory, String defaultOutputFolder) {
        if (this.altBuildDir != null) {
            File buildDirectory = outputDirectory.getParentFile();
            File projectDirectory = buildDirectory.getParentFile();
            String name = buildDirectory.getName();
            if (name.equals("target")) {
                File altBuildDirectory = new File(projectDirectory, this.altBuildDir);
                if (altBuildDirectory.isDirectory()) {
                    File altOutputDirectory = new File(altBuildDirectory, defaultOutputFolder);
                    this.add(altOutputDirectory, null);
                }
            } else if (name.equals(this.altBuildDir)) {
                this.add(outputDirectory, null);
                buildDirectory = new File(projectDirectory, "target");
                outputDirectory = new File(buildDirectory, defaultOutputFolder);
            }
        }
        this.add(outputDirectory, null);
    }

    private void collect(Model model, String modelGav, boolean includeTest, int recursiveness) {
        if (model == null) {
            return;
        }
        if (recursiveness >= 100) {
            LOG.warn("Skipping transitive dependency at {} after 100 recursions!", (Object)model);
            return;
        }
        ++recursiveness;
        List dependencies = model.getDependencies();
        LOG.trace("Start scanning dependencies of {}", (Object)model);
        for (Dependency dependency : dependencies) {
            boolean isTestDependency = "test".equals(dependency.getScope());
            if (includeTest || !isTestDependency) {
                if (recursiveness != 0 && dependency.isOptional()) continue;
                Model dependencyModel = null;
                String dependencyGav = DependencyHelper.getGav((Dependency)dependency);
                if (this.buildReactor) {
                    dependencyModel = this.gav2ProjectMap.get(dependencyGav);
                }
                if (dependencyModel == null) {
                    File artifact = this.mavenBridge.findArtifact(dependency);
                    boolean added = this.add(artifact, modelGav);
                    if (!added) continue;
                    File artifactPom = this.mavenBridge.findPom(dependency);
                    dependencyModel = this.mavenBridge.readEffectiveModelFromLocationWithFallback(artifactPom);
                } else {
                    this.addOutputDirectories(dependencyModel);
                }
                this.collect(dependencyModel, dependencyGav, isTestDependency, recursiveness);
                continue;
            }
            LOG.debug("Omitting optional dependency {}", (Object)dependency);
        }
        LOG.trace("Done scanning dependencies of {}", (Object)model);
    }

    static File normalize(File file) {
        try {
            file = file.getAbsoluteFile();
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOG.debug("Failed to normize file {}", (Object)file, (Object)e);
            return file;
        }
    }
}

