/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.loader;

import io.github.mmm.code.api.CodeName;
import io.github.mmm.code.api.item.CodeItem;
import io.github.mmm.code.base.BaseContext;
import io.github.mmm.code.base.BaseFile;
import io.github.mmm.code.base.BasePackage;
import io.github.mmm.code.base.BasePathElement;
import io.github.mmm.code.base.BasePathElements;
import io.github.mmm.code.base.loader.BaseSourceLoaderImpl;
import io.github.mmm.code.base.loader.SourceCodeProvider;
import io.github.mmm.code.base.node.BaseNodeItemContainer;
import io.github.mmm.code.base.parser.SourceCodeParser;
import io.github.mmm.code.base.source.BaseSource;
import io.github.mmm.code.base.type.BaseGenericType;
import io.github.mmm.code.base.type.BaseType;
import io.github.mmm.code.impl.java.parser.JavaSourceCodeParserImpl;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourceLoader
extends BaseSourceLoaderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSourceLoader.class);
    private SourceCodeProvider sourceCodeProvider;
    private SourceCodeParser parser;

    public JavaSourceLoader(SourceCodeProvider sourceCodeProvider) {
        this.sourceCodeProvider = sourceCodeProvider;
    }

    public SourceCodeParser getParser() {
        if (this.parser == null) {
            this.parser = JavaSourceCodeParserImpl.get();
        }
        return this.parser;
    }

    public void setParser(SourceCodeParser parser) {
        if (this.parser == null) {
            this.parser = parser;
        }
        if (this.parser == parser) {
            throw new IllegalStateException("Already initialized!");
        }
    }

    public SourceCodeProvider getSourceCodeProvider() {
        return this.sourceCodeProvider;
    }

    public BaseType getType(String qualifiedName) {
        if (this.sourceCodeProvider == null) {
            return null;
        }
        return this.getType(this.getSource().parseName(qualifiedName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BaseType getType(CodeName qualifiedName) {
        if (this.sourceCodeProvider == null) {
            return null;
        }
        CodeName parent = qualifiedName.getParent();
        try (Reader reader = this.sourceCodeProvider.openType(qualifiedName.getFullName());){
            if (reader == null) {
                BaseType baseType2 = this.getTypeFromSource(parent, qualifiedName.getSimpleName());
                return baseType2;
            }
            BasePackage pkg = this.getPackage(parent);
            BaseFile file = pkg.getChildren().createFile(qualifiedName.getSimpleName());
            this.getParser().parseType(reader, file);
            BaseType baseType = file.getType();
            return baseType;
        }
        catch (IOException e) {
            LOG.debug("Failed to open type: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public BaseGenericType getType(Class<?> clazz) {
        BasePackage parentPackage;
        BaseSource source;
        if (clazz.isArray()) {
            BaseGenericType componentType = this.getType(clazz.getComponentType());
            return componentType.createArray();
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (!Objects.equals(codeSource, (source = this.getSource()).getReflectiveObject())) {
            URL location = null;
            if (codeSource != null) {
                location = codeSource.getLocation();
            }
            throw new IllegalStateException(source.getId() + " not responsible for location " + location);
        }
        Package pkg = clazz.getPackage();
        if (pkg == null) {
            parentPackage = this.getSource().getRootPackage();
        } else {
            String pkgName = pkg.getName();
            parentPackage = this.getPackage(source.parseName(pkgName));
        }
        return this.getTypeInternal(clazz, parentPackage);
    }

    private BaseType getTypeInternal(Class<?> clazz, BasePackage pkg) {
        String simpleName = clazz.getSimpleName();
        Class<?> declaringClass = clazz.getDeclaringClass();
        BaseType type = (BaseType)pkg.getChildren().getType(simpleName, false);
        if (type != null) {
            return type;
        }
        BaseType declaringType = null;
        if (declaringClass != null) {
            declaringType = this.getTypeInternal(declaringClass, pkg);
            BaseFile file = declaringType.getFile();
            type = new BaseType(file, simpleName, declaringType, clazz);
            JavaSourceLoader.addContainerItem((BaseNodeItemContainer)declaringType.getNestedTypes(), (CodeItem)type);
        } else {
            BaseFile file = new BaseFile(pkg, clazz, this.getSourceFileSupplier(pkg, clazz.getSimpleName()));
            JavaSourceLoader.addPathElementInternal((BasePathElements)pkg.getChildren(), (BasePathElement)file);
            type = file.getType();
        }
        return type;
    }

    private BasePackage getPackage(CodeName qualifiedName) {
        BasePackage pkg = this.getSource().getRootPackage();
        if (qualifiedName != null) {
            pkg = JavaSourceLoader.getPackage((BasePathElements)pkg.getChildren(), (CodeName)qualifiedName, (boolean)false, this::createPackage, (boolean)true, (boolean)true);
        }
        return pkg;
    }

    private BasePackage createPackage(BasePackage parentPackage, String simpleName) {
        BasePackage pkg = new BasePackage(parentPackage, simpleName, null, () -> this.getSourcePackage(parentPackage, simpleName), true);
        return pkg;
    }

    private BasePackage getSourcePackage(BasePackage parentPackage, String simpleName) {
        if (this.sourceCodeProvider == null) {
            return null;
        }
        BasePackage pkg = new BasePackage(parentPackage, simpleName, null, null, true);
        try (Reader reader = this.sourceCodeProvider.openPackage(pkg.getQualifiedName());){
            if (reader != null) {
                this.getParser().parsePackage(reader, pkg);
            }
        }
        catch (IOException e) {
            LOG.debug("Open package failed: {}", (Object)e.getMessage(), (Object)e);
        }
        return pkg;
    }

    private Supplier<BaseFile> getSourceFileSupplier(BasePackage pkg, String simpleName) {
        if (this.sourceCodeProvider == null) {
            return null;
        }
        return () -> this.getFileFromSource(pkg, simpleName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BaseFile getFileFromSource(BasePackage pkg, String simpleName) {
        BaseFile file = pkg.getChildren().createFile(simpleName);
        try (Reader reader = this.sourceCodeProvider.openType(file.getQualifiedName());){
            if (reader == null) return null;
            this.getParser().parseType(reader, file);
            BaseFile baseFile = file;
            return baseFile;
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("Failed to open type: {}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private BaseType getTypeFromSource(CodeName parent, String simpleName) {
        BaseType declaringType;
        if (parent == null) {
            return null;
        }
        String parentSimpleName = parent.getSimpleName();
        if (parentSimpleName.length() > 0 && Character.isUpperCase(parentSimpleName.charAt(0)) && (declaringType = this.getTypeFromSource(parent.getParent(), parentSimpleName)) != null) {
            return (BaseType)declaringType.getNestedTypes().get(simpleName);
        }
        return null;
    }

    public void scan(BasePackage pkg) {
        if (this.sourceCodeProvider != null) {
            try {
                String qualifiedName = pkg.getQualifiedName();
                List simpleNames = this.sourceCodeProvider.scanPackage(qualifiedName);
                BaseContext context = this.getContext();
                String prefix = qualifiedName + context.getLanguage().getPackageSeparator();
                for (String simpleName : simpleNames) {
                    context.getType(prefix + simpleName);
                }
            }
            catch (IOException e) {
                LOG.debug("Package scan failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void close() {
        if (this.sourceCodeProvider != null) {
            this.sourceCodeProvider.close();
            this.sourceCodeProvider = null;
        }
    }
}

