/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralChar
extends JavaLiteral<Character> {
    public static final JavaLiteralChar VALUE_0 = new JavaLiteralChar(Character.valueOf('\u0000'));
    public static final JavaLiteralChar VALUE_MIN = new JavaLiteralChar(Character.valueOf('\u0000'));
    public static final JavaLiteralChar VALUE_MAX = new JavaLiteralChar(Character.valueOf('\uffff'));

    private JavaLiteralChar(Character value) {
        super(value);
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Character.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Character.MAX_VALUE";
        }
        return JavaLiteralChar.toCharLiteral(((Character)this.getValue()).charValue());
    }

    public static String toCharLiteral(char value) {
        Object literal;
        if (value == '\n') {
            literal = "'\n'";
        } else if (value == '\r') {
            literal = "'\r'";
        } else if (value == '\t') {
            literal = "'\t'";
        } else if (value == '\"') {
            literal = "'\\\"'";
        } else if (value == '\u0000') {
            literal = "'\u0000'";
        } else if (value >= ' ' && value < '\u00ff' && value != '\u007f') {
            literal = "'" + value + "'";
        } else {
            Object hex = Integer.toString(value, 16);
            while (((String)hex).length() < 4) {
                hex = "0" + (String)hex;
            }
            literal = "'\\u" + (String)hex + "'";
        }
        return literal;
    }

    public JavaLiteralChar withValue(Character newValue) {
        return new JavaLiteralChar(newValue);
    }

    @Override
    public Class<Character> getJavaClass() {
        return Character.TYPE;
    }

    public static JavaLiteralChar of(char value) {
        return JavaLiteralChar.of(Character.valueOf(value));
    }

    public static JavaLiteralChar of(Character value) {
        char c = value.charValue();
        if (c == '\u0000') {
            return VALUE_0;
        }
        return new JavaLiteralChar(value);
    }
}

