/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.operator;

import io.github.mmm.code.api.operator.CodeNAryOperator;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregate;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateDouble;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateFloat;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateLong;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateNumeric;

class JavaNAryOperatorAggregateInt
extends JavaNAryOperatorAggregateNumeric<Integer> {
    private int value;

    JavaNAryOperatorAggregateInt(CodeNAryOperator operator, int value) {
        super(operator);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public JavaNAryOperatorAggregate<?> evaluate(Object arg) {
        if (arg instanceof Long) {
            return new JavaNAryOperatorAggregateLong(this.operator, this.value).evaluate(arg);
        }
        if (arg instanceof Float) {
            return new JavaNAryOperatorAggregateFloat(this.operator, this.value).evaluate(arg);
        }
        if (arg instanceof Double) {
            return new JavaNAryOperatorAggregateDouble(this.operator, this.value).evaluate(arg);
        }
        return super.evaluate(arg);
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> add(Number arg) {
        this.value += arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> sub(Number arg) {
        this.value -= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> mul(Number arg) {
        this.value *= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> div(Number arg) {
        this.value /= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> mod(Number arg) {
        this.value %= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> xor(Number arg) {
        this.value ^= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> shiftLeft(Number arg) {
        this.value <<= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> shiftRightSigned(Number arg) {
        this.value >>= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> shiftRightUnsigned(Number arg) {
        this.value >>>= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> bitOr(Number arg) {
        this.value |= arg.intValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> bitAnd(Number arg) {
        this.value &= arg.intValue();
        return this;
    }
}

