/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java;

import io.github.mmm.code.api.language.CodeLanguage;
import io.github.mmm.code.api.language.JavaLanguage;
import io.github.mmm.code.api.node.CodeNodeItem;
import io.github.mmm.code.api.source.CodeSourceDescriptor;
import io.github.mmm.code.base.loader.BaseLoader;
import io.github.mmm.code.base.loader.BaseSourceLoader;
import io.github.mmm.code.base.loader.SourceCodeProvider;
import io.github.mmm.code.base.source.BaseSourceDescriptorType;
import io.github.mmm.code.base.source.BaseSourceImpl;
import io.github.mmm.code.base.type.BaseType;
import io.github.mmm.code.base.type.BaseTypeWildcard;
import io.github.mmm.code.impl.java.JavaConstants;
import io.github.mmm.code.impl.java.JavaContext;
import io.github.mmm.code.impl.java.JavaFactory;
import io.github.mmm.code.impl.java.loader.JavaSourceLoader;
import java.io.File;

public class JavaRootContext
extends JavaContext {
    private static JavaRootContext instance;
    private final JavaContext.JavaClassLoader loader = new JavaContext.JavaClassLoader(ClassLoader.getSystemClassLoader());
    private final JavaFactory factory = new JavaFactory();
    private BaseTypeWildcard unboundedWildcard;

    public JavaRootContext(BaseSourceImpl source) {
        super(source);
        for (Class<?> primitive : JavaConstants.PRIMITIVE_TYPES) {
            this.getType(primitive);
        }
    }

    public JavaContext getParent() {
        return null;
    }

    @Override
    public JavaRootContext getRootContext() {
        return this;
    }

    protected BaseLoader getLoader() {
        return this.loader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader.getClassLoader();
    }

    public CodeLanguage getLanguage() {
        return JavaLanguage.get();
    }

    public BaseType getRootType() {
        return (BaseType)this.getType(Object.class);
    }

    public BaseType getRootEnumerationType() {
        return (BaseType)this.getType(Enum.class);
    }

    public BaseType getRootExceptionType() {
        return (BaseType)this.getType(Throwable.class);
    }

    public BaseType getVoidType() {
        return (BaseType)this.getType(Void.TYPE);
    }

    public BaseType getBooleanType(boolean primitive) {
        if (primitive) {
            return (BaseType)this.getType(Boolean.TYPE);
        }
        return (BaseType)this.getType(Boolean.class);
    }

    public BaseTypeWildcard getUnboundedWildcard() {
        if (this.unboundedWildcard == null) {
            this.unboundedWildcard = new BaseTypeWildcard((CodeNodeItem)this.getRootType(), JavaConstants.UNBOUNDED_WILDCARD);
        }
        return this.unboundedWildcard;
    }

    public BaseType getNonPrimitiveType(BaseType javaType) {
        if (javaType.isPrimitive()) {
            String qualifiedName = JavaConstants.JAVA_PRIMITIVE_TYPES_MAP.get(javaType.getSimpleName());
            if (qualifiedName == null) {
                throw new IllegalArgumentException(javaType.toString());
            }
            return this.getType(qualifiedName);
        }
        return javaType;
    }

    public String getQualifiedNameForStandardType(String simpleName, boolean omitStandardPackages) {
        if (JavaConstants.JAVA_LANG_TYPES.contains(simpleName)) {
            if (omitStandardPackages) {
                return simpleName;
            }
            return "java.lang." + simpleName;
        }
        if (JavaConstants.JAVA_PRIMITIVE_TYPES_MAP.containsKey(simpleName)) {
            return simpleName;
        }
        return null;
    }

    public JavaFactory getFactory() {
        return this.factory;
    }

    private static BaseSourceImpl createRootSource() {
        SourceCodeProvider sourceCodeProvider = null;
        JavaSourceLoader loader = new JavaSourceLoader(sourceCodeProvider);
        String javaHome = System.getProperty("java.home");
        File byteCodeLocation = new File(javaHome);
        String version = System.getProperty("java.version");
        String majorVersion = JavaRootContext.getJavaMajorVersion(version);
        String docUrl = "http://docs.oracle.com/javase/" + majorVersion + "/docs/api/";
        String groupId = "java";
        String artifactId = "jre";
        File jdkHome = byteCodeLocation.getParentFile();
        File srcZip = new File(jdkHome, "src.zip");
        File sourceCodeLocation = null;
        if (srcZip.isFile()) {
            artifactId = "jdk";
            sourceCodeLocation = srcZip;
        }
        BaseSourceDescriptorType descriptor = new BaseSourceDescriptorType(groupId, artifactId, version, null, docUrl);
        return new BaseSourceImpl(byteCodeLocation, sourceCodeLocation, null, (CodeSourceDescriptor)descriptor, (BaseSourceLoader)loader);
    }

    private static String getJavaMajorVersion(String version) {
        int underscoreIndex;
        String majorVersion = version.startsWith("1.") ? version.substring(2) : version;
        int dotIndex = majorVersion.indexOf(46);
        if (dotIndex > 0) {
            majorVersion = majorVersion.substring(0, dotIndex);
        }
        if ((underscoreIndex = majorVersion.indexOf(95)) > 0) {
            majorVersion = majorVersion.substring(0, underscoreIndex);
        }
        return majorVersion;
    }

    public static JavaRootContext get() {
        if (instance == null) {
            BaseSourceImpl source = JavaRootContext.createRootSource();
            instance = new JavaRootContext(source);
        }
        return instance;
    }
}

