/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.api.expression.CodeLiteral;
import io.github.mmm.code.impl.java.expression.constant.JavaConstant;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralBoolean;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralChar;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralClass;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralDouble;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralFloat;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralInt;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralLong;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralNull;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralShort;
import io.github.mmm.code.impl.java.expression.literal.JavaLiteralString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaLiteral<T>
extends JavaConstant<T>
implements CodeLiteral {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLiteral.class);

    protected JavaLiteral(T value) {
        super(value);
    }

    @Override
    public JavaLiteral<T> evaluate() {
        return this;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public abstract JavaLiteral<T> withValue(T var1);

    public static JavaLiteral<?> of(Object value) {
        if (value == null) {
            return JavaLiteralNull.NULL;
        }
        if (value instanceof Boolean) {
            return JavaLiteralBoolean.of((Boolean)value);
        }
        if (value instanceof Integer) {
            return JavaLiteralInt.of((Integer)value);
        }
        if (value instanceof Long) {
            return JavaLiteralLong.of((Long)value);
        }
        if (value instanceof Short) {
            return JavaLiteralShort.of((Short)value);
        }
        if (value instanceof Float) {
            return JavaLiteralFloat.of((Float)value);
        }
        if (value instanceof Double) {
            return JavaLiteralDouble.of((Double)value);
        }
        if (value instanceof Character) {
            return JavaLiteralChar.of((Character)value);
        }
        if (value instanceof String) {
            return JavaLiteralString.of((String)value);
        }
        if (value instanceof Class) {
            return JavaLiteralClass.of((Class)value);
        }
        LOG.debug("Undefined value type for literal: {}", value);
        return null;
    }
}

