/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.expression.literal;

import io.github.mmm.code.impl.java.expression.literal.JavaLiteral;

public final class JavaLiteralDouble
extends JavaLiteral<Double> {
    public static final JavaLiteralDouble VALUE_0 = new JavaLiteralDouble(0.0);
    public static final JavaLiteralDouble VALUE_1 = new JavaLiteralDouble(1.0);
    public static final JavaLiteralDouble VALUE_MIN = new JavaLiteralDouble((Double)Double.MIN_VALUE);
    public static final JavaLiteralDouble VALUE_MAX = new JavaLiteralDouble((Double)Double.MAX_VALUE);

    private JavaLiteralDouble(Double value) {
        super(value);
    }

    public JavaLiteralDouble withValue(Double newValue) {
        return new JavaLiteralDouble(newValue);
    }

    @Override
    public Class<Double> getJavaClass() {
        return Double.TYPE;
    }

    @Override
    public String getSourceCode() {
        if (this == VALUE_MIN) {
            return "Double.MIN_VALUE";
        }
        if (this == VALUE_MAX) {
            return "Double.MAX_VALUE";
        }
        return ((Double)this.getValue()).toString() + "D";
    }

    public static JavaLiteralDouble of(double value) {
        return JavaLiteralDouble.of((Double)value);
    }

    public static JavaLiteralDouble of(Double value) {
        if (value == 0.0) {
            return VALUE_0;
        }
        if (value == 1.0) {
            return VALUE_1;
        }
        return new JavaLiteralDouble(value);
    }
}

