/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.operator;

import io.github.mmm.code.api.operator.CodeNAryOperator;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregate;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateDouble;
import io.github.mmm.code.impl.java.operator.JavaNAryOperatorAggregateNumeric;

class JavaNAryOperatorAggregateFloat
extends JavaNAryOperatorAggregateNumeric<Float> {
    private float value;

    JavaNAryOperatorAggregateFloat(CodeNAryOperator operator, float value) {
        super(operator);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public JavaNAryOperatorAggregate<?> evaluate(Object arg) {
        if (arg instanceof Double) {
            return new JavaNAryOperatorAggregateDouble(this.operator, this.value).evaluate(arg);
        }
        return super.evaluate(arg);
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> add(Number arg) {
        this.value += arg.floatValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> sub(Number arg) {
        this.value -= arg.floatValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> mul(Number arg) {
        this.value *= arg.floatValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> div(Number arg) {
        this.value /= arg.floatValue();
        return this;
    }

    @Override
    protected JavaNAryOperatorAggregateNumeric<?> mod(Number arg) {
        this.value %= arg.floatValue();
        return this;
    }
}

