/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.impl.java.parser;

import io.github.mmm.code.api.CodeFile;
import io.github.mmm.code.api.annotation.CodeAnnotation;
import io.github.mmm.code.api.comment.CodeComment;
import io.github.mmm.code.api.copy.CodeCopyMapper;
import io.github.mmm.code.api.element.CodeElement;
import io.github.mmm.code.api.element.CodeElementWithTypeVariables;
import io.github.mmm.code.api.node.CodeNodeItem;
import io.github.mmm.code.api.type.CodeGenericType;
import io.github.mmm.code.api.type.CodeTypePlaceholder;
import io.github.mmm.code.base.BaseContext;
import io.github.mmm.code.base.BaseFile;
import io.github.mmm.code.base.annoation.BaseAnnotations;
import io.github.mmm.code.base.type.BaseComposedType;
import io.github.mmm.code.base.type.BaseGenericType;
import io.github.mmm.code.base.type.BaseGenericTypeProxy;
import io.github.mmm.code.base.type.BaseParameterizedType;
import io.github.mmm.code.base.type.BaseType;
import io.github.mmm.code.base.type.BaseTypeParameters;
import io.github.mmm.code.base.type.BaseTypeProxy;
import io.github.mmm.code.base.type.BaseTypeVariable;
import io.github.mmm.code.base.type.BaseTypeWildcard;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JavaGenericTypeFromSource
extends BaseGenericTypeProxy {
    private final CodeElementWithTypeVariables parent;
    private final String name;
    private final BaseFile file;
    private BaseGenericType type;
    private List<BaseGenericType> composedTypes;
    private List<BaseGenericType> typeParameters;
    private BaseGenericType extendsBound;
    private BaseGenericType superBound;
    private int arrayCount;
    private String arrayLengthExpression;
    private boolean commentAndAnnotationsApplied;

    public JavaGenericTypeFromSource(CodeElementWithTypeVariables parent, String name, BaseFile file) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(file, "file");
        this.parent = parent;
        this.name = name;
        this.file = file;
    }

    public BaseGenericType getDelegate() {
        if (this.type == null) {
            this.type = (BaseGenericType)this.toGenericType(null);
        }
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    private CodeGenericType toGenericType(CodeTypePlaceholder placeholder) {
        if ("?".equals(this.name)) {
            return this.toWildcardType();
        }
        CodeGenericType genericType = this.toGenericTypeByName(this.name);
        if (this.composedTypes != null) {
            BaseComposedType composedType = new BaseComposedType(placeholder);
            composedType.add(genericType);
            for (BaseGenericType interfaceType : this.composedTypes) {
                composedType.add(JavaGenericTypeFromSource.resolve((CodeGenericType)interfaceType, placeholder));
            }
            this.applyCommentAndAnnotations((CodeGenericType)composedType);
            composedType.setImmutable();
            genericType = composedType;
        }
        if (this.typeParameters != null && !this.typeParameters.isEmpty()) {
            BaseType javaType = (BaseType)genericType;
            BaseParameterizedType parameterizedType = javaType.createParameterizedType((CodeElement)this.parent);
            BaseTypeParameters parameters = parameterizedType.getTypeParameters();
            for (BaseGenericType typeParam : this.typeParameters) {
                parameters.add(JavaGenericTypeFromSource.resolve((CodeGenericType)typeParam, placeholder));
            }
            this.applyCommentAndAnnotations((CodeGenericType)parameterizedType);
            parameterizedType.setImmutable();
            genericType = parameterizedType;
        }
        if (this.arrayCount > 0) {
            for (int i = 0; i < this.arrayCount; ++i) {
                genericType = genericType.createArray();
            }
            genericType = this.applyCommentAndAnnotations(genericType);
        }
        return genericType;
    }

    private CodeGenericType toGenericTypeByName(String typeName) {
        boolean qualified;
        BaseTypeVariable typeVariable = (BaseTypeVariable)this.parent.getTypeParameters().get(typeName, true);
        if (typeVariable != null) {
            return typeVariable;
        }
        BaseContext context = (BaseContext)this.parent.getContext();
        String qualifiedName = typeName;
        boolean bl = qualified = typeName.indexOf(46) > 0;
        if (!qualified) {
            qualifiedName = context.getQualifiedName(typeName, (CodeFile)this.file, false);
        }
        BaseType baseType = context.getOrCreateType(qualifiedName, false);
        if (qualified) {
            BaseTypeProxy qualifiedType = new BaseTypeProxy((CodeElement)this.parent, baseType);
            qualifiedType.setQualified(true);
            this.applyCommentAndAnnotations((CodeGenericType)qualifiedType);
            qualifiedType.setImmutable();
            return qualifiedType;
        }
        return baseType;
    }

    private CodeGenericType applyCommentAndAnnotations(CodeGenericType genericType) {
        CodeComment comment;
        if (this.commentAndAnnotationsApplied) {
            return genericType;
        }
        CodeGenericType result = genericType;
        BaseAnnotations annotations = this.getAnnotations(false);
        if (annotations != null) {
            if (result instanceof BaseType) {
                result = new BaseTypeProxy((CodeElement)this.parent, (BaseType)genericType);
            }
            assert (result.getAnnotations().getDeclared().isEmpty());
            for (CodeAnnotation annotation : annotations) {
                result.getAnnotations().add(annotation);
            }
        }
        if ((comment = this.getComment(false)) != null) {
            if (result instanceof BaseType) {
                result = new BaseTypeProxy((CodeElement)this.parent, (BaseType)genericType);
            }
            assert (result.getComment() == null);
            result.setComment(comment);
        }
        this.commentAndAnnotationsApplied = true;
        return result;
    }

    private static CodeGenericType resolve(CodeGenericType type, CodeTypePlaceholder placeholder) {
        if (type instanceof JavaGenericTypeFromSource) {
            return ((JavaGenericTypeFromSource)type).toGenericType(placeholder);
        }
        return type;
    }

    private CodeGenericType toWildcardType() {
        BaseTypeWildcard wildcard;
        CodeGenericType bound = null;
        if (this.extendsBound != null) {
            wildcard = new BaseTypeWildcard((CodeNodeItem)this.parent, null, false);
            bound = JavaGenericTypeFromSource.resolve((CodeGenericType)this.extendsBound, (CodeTypePlaceholder)wildcard);
        } else if (this.superBound != null) {
            wildcard = new BaseTypeWildcard((CodeNodeItem)this.parent, null, true);
            bound = JavaGenericTypeFromSource.resolve((CodeGenericType)this.superBound, (CodeTypePlaceholder)wildcard);
        } else {
            wildcard = this.parent.getContext().getUnboundedWildcard();
        }
        if (bound != null) {
            wildcard.setBound(bound);
            this.applyCommentAndAnnotations((CodeGenericType)wildcard);
            wildcard.setImmutable();
        }
        return wildcard;
    }

    public boolean isDiamonOperator() {
        return this.typeParameters != null && this.typeParameters.isEmpty();
    }

    public void ensureTypeParameters() {
        if (this.typeParameters == null) {
            this.typeParameters = new ArrayList<BaseGenericType>();
        }
    }

    public void addTypeParameter(BaseGenericType typeParameter) {
        this.ensureTypeParameters();
        this.typeParameters.add(typeParameter);
    }

    public void addComposedType(BaseGenericType composedType) {
        if (this.composedTypes == null) {
            this.composedTypes = new ArrayList<BaseGenericType>();
        }
        this.composedTypes.add(composedType);
    }

    public BaseGenericType getExtendsBound() {
        return this.extendsBound;
    }

    public void setExtendsBound(BaseGenericType extendsBound) {
        this.extendsBound = extendsBound;
    }

    public BaseGenericType getSuperBound() {
        return this.superBound;
    }

    public void setSuperBound(BaseGenericType superBound) {
        this.superBound = superBound;
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void incArrayCount() {
        ++this.arrayCount;
    }

    public String getArrayLengthExpression() {
        return this.arrayLengthExpression;
    }

    public void setArrayLengthExpression(String arrayLengthExpression) {
        this.arrayLengthExpression = arrayLengthExpression;
    }

    public BaseGenericType copy() {
        BaseGenericType delegate = this.getDelegate();
        if (delegate.isImmutable()) {
            delegate = delegate.copy();
        }
        return delegate;
    }

    public BaseGenericType copy(CodeCopyMapper mapper) {
        BaseGenericType delegate = this.getDelegate();
        if (delegate.isImmutable()) {
            delegate = delegate.copy(mapper);
        }
        return delegate;
    }
}

