/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.java.maven.impl;

import io.github.mmm.base.exception.RuntimeIoException;
import io.github.mmm.code.java.maven.api.MavenBridge;
import io.github.mmm.code.java.maven.api.MavenConstants;
import io.github.mmm.code.java.maven.impl.MavenLocalRepositoryLocator;
import io.github.mmm.code.java.maven.impl.MavenResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.resolution.ModelResolver;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenBridgeImpl
implements MavenBridge,
MavenConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MavenBridgeImpl.class);
    private static final Pattern PATTERN_PROPERTY_PARAMETER = Pattern.compile("-D([a-zA-Z0-9.-_]+)=\"?(([^ ]| (?!-D))*)\"?");
    private static final MavenBridgeImpl INSTANCE = new MavenBridgeImpl();
    private final MavenXpp3Reader pomReader = new MavenXpp3Reader();
    private final MavenResolver resolver;

    public MavenBridgeImpl() {
        this(null);
    }

    public MavenBridgeImpl(File localRepository) {
        File localRepo = localRepository;
        if (localRepo == null) {
            localRepo = MavenLocalRepositoryLocator.getLocalRepository(this);
        }
        this.resolver = new MavenResolver(localRepo);
    }

    @Override
    public File findPom(File source) {
        String filename = source.getName();
        if (source.isFile()) {
            String basename;
            File pomFile;
            int lastDot = filename.lastIndexOf(46);
            if (lastDot > 0 && (pomFile = (basename = filename.substring(0, lastDot)).equals("pom") ? source : new File(source.getParent(), basename + ".pom")).exists()) {
                return pomFile;
            }
            int lastSlash = filename.indexOf(45);
            if (lastSlash > 0) {
                basename = filename.substring(0, lastSlash);
                pomFile = new File(source.getParent(), basename + ".pom");
                if (pomFile.exists()) {
                    return pomFile;
                }
            }
        } else if (source.isDirectory()) {
            return this.findPomFromFolder(source, 0);
        }
        return null;
    }

    @Override
    public File findArtifactSources(File artifact) {
        String filename;
        int lastDot;
        if (artifact.isFile() && (lastDot = (filename = artifact.getName()).lastIndexOf(46)) > 0) {
            String extension = filename.substring(lastDot);
            String sourcesBasename = filename.substring(0, lastDot) + "-sources";
            File sourcesFile = new File(artifact.getParent(), sourcesBasename + extension);
            if (sourcesFile.exists()) {
                return sourcesFile;
            }
            sourcesFile = new File(artifact.getParent(), sourcesBasename + ".zip");
            if (sourcesFile.exists()) {
                return sourcesFile;
            }
        }
        return null;
    }

    private File findPomFromFolder(File folder, int recursion) {
        if (folder == null) {
            return null;
        }
        File pomFile = new File(folder, "pom.xml");
        if (pomFile.exists()) {
            return pomFile;
        }
        if (recursion > 4) {
            return null;
        }
        return this.findPomFromFolder(folder.getParentFile(), recursion + 1);
    }

    @Override
    public File findPom(Dependency dependency) {
        return this.resolver.resolvePom(dependency);
    }

    @Override
    public File findArtifact(Dependency dependency) {
        return this.resolver.resolveArtifact(dependency);
    }

    @Override
    public Model readModel(File pomFile) {
        Model model;
        LOG.debug("Reading raw model of {}", (Object)pomFile);
        FileInputStream in = new FileInputStream(pomFile);
        try {
            Model model2 = this.pomReader.read((InputStream)in);
            model2.setPomFile(pomFile);
            model = model2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeIoException((Throwable)e);
            }
            catch (XmlPullParserException e) {
                throw new IllegalStateException("XML is invalid in " + pomFile, e);
            }
        }
        ((InputStream)in).close();
        return model;
    }

    @Override
    public Model readEffectiveModel(File pomFile) {
        LOG.debug("Reading effective model of {}", (Object)pomFile);
        try {
            Properties properties = System.getProperties();
            properties = this.resolveProperties(properties, pomFile.getAbsoluteFile().getParentFile());
            DefaultModelBuildingRequest buildingRequest = new DefaultModelBuildingRequest().setSystemProperties(properties).setPomFile(pomFile).setModelResolver((ModelResolver)this.resolver);
            DefaultModelBuilder defaultModelBuilder = new DefaultModelBuilderFactory().newInstance();
            ModelBuildingResult buildingResult = defaultModelBuilder.build((ModelBuildingRequest)buildingRequest);
            return buildingResult.getEffectiveModel();
        }
        catch (ModelBuildingException e) {
            throw new IllegalStateException("Failed to read effective model for " + pomFile + ". Try to run 'mvn help:effective-pom' in that folder manually. If that fails, fix your pom.xml. Otherwise report a bug at https://github.com/m-m-m/code/issues/new/choose", e);
        }
    }

    @Override
    public Model readEffectiveModelFromLocation(File location, boolean fallback) {
        File pomFile = this.findPom(location);
        if (pomFile == null || !pomFile.isFile()) {
            return null;
        }
        try {
            return this.readEffectiveModel(pomFile);
        }
        catch (Throwable e) {
            if (fallback) {
                LOG.warn("Failed to resolve effective POM for {}. Trying to continue without resolving effective POM...", (Object)location, (Object)e);
                return this.readModel(pomFile);
            }
            throw e;
        }
    }

    private Properties resolveProperties(Properties properties, File projectBaseDir) {
        if (projectBaseDir.getParentFile() == null) {
            return properties;
        }
        try {
            File mvnConfig;
            File mvnDir = new File(projectBaseDir, ".mvn");
            if (mvnDir.isDirectory() && (mvnConfig = new File(mvnDir, "maven.config")).isFile()) {
                List<String> lines = Files.readAllLines(mvnConfig.toPath());
                for (String line : lines) {
                    this.resolveProperties(properties, line.trim());
                }
                return properties;
            }
            return this.resolveProperties(properties, projectBaseDir.getParentFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading maven.config from " + projectBaseDir, e);
        }
    }

    private void resolveProperties(Properties properties, String line) {
        Matcher matcher = PATTERN_PROPERTY_PARAMETER.matcher(line);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            properties.put(key, value);
        }
    }

    public static MavenBridge getDefault() {
        return INSTANCE;
    }
}

