/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.java.maven.api;

import io.github.mmm.code.java.maven.api.MavenConstants;
import java.util.Collection;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;

public class DependencyHelper
implements MavenConstants {
    public static boolean equals(Dependency dep1, Dependency dep2) {
        if (dep1 == dep2) {
            return true;
        }
        if (!DependencyHelper.matches(dep1.getGroupId(), dep2.getGroupId())) {
            return false;
        }
        if (!DependencyHelper.matches(dep1.getArtifactId(), dep2.getArtifactId())) {
            return false;
        }
        if (!DependencyHelper.matches(dep1.getVersion(), dep2.getVersion())) {
            return false;
        }
        if (!DependencyHelper.matches(DependencyHelper.getType(dep1), DependencyHelper.getType(dep2))) {
            return false;
        }
        if (!DependencyHelper.matches(DependencyHelper.getScope(dep1), DependencyHelper.getScope(dep2))) {
            return false;
        }
        if (dep1.isOptional() != dep2.isOptional()) {
            return false;
        }
        if (!DependencyHelper.matches(dep1.getClassifier(), dep2.getClassifier())) {
            return false;
        }
        return DependencyHelper.matches(dep1.getSystemPath(), dep2.getSystemPath());
    }

    private static boolean matches(String s1, String s2) {
        if ("*".equals(s1) || "*".equals(s2)) {
            return true;
        }
        return Objects.equals(s1, s2);
    }

    public static String getScope(Dependency dependency) {
        String scope = dependency.getScope();
        if (scope == null) {
            scope = "compile";
        }
        return scope;
    }

    public static String getType(Dependency dependency) {
        String type = dependency.getType();
        if (type == null) {
            type = "jar";
        }
        return type;
    }

    public static Dependency findFirst(Collection<Dependency> dependencies, Dependency dependency) {
        return dependencies.stream().filter(x -> DependencyHelper.equals(x, dependency)).findFirst().orElse(null);
    }

    public static int containsCount(Collection<Dependency> dependencies, Dependency dependency) {
        return (int)dependencies.stream().filter(x -> DependencyHelper.equals(x, dependency)).count();
    }

    public static boolean contains(Collection<Dependency> dependencies, Dependency dependency) {
        return DependencyHelper.containsCount(dependencies, dependency) > 0;
    }

    public static Dependency create(Parent parent) {
        return DependencyHelper.create(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), "compile", "pom");
    }

    public static Dependency create(String groupId, String artifactId, String version) {
        return DependencyHelper.create(groupId, artifactId, version, "compile");
    }

    public static Dependency create(String groupId, String artifactId, String version, String scope) {
        return DependencyHelper.create(groupId, artifactId, version, scope, "jar");
    }

    public static Dependency create(String groupId, String artifactId, String version, String scope, String type) {
        return DependencyHelper.create(groupId, artifactId, version, scope, type, null);
    }

    public static Dependency create(String groupId, String artifactId, String version, String scope, String type, String classifier) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setType(type);
        dependency.setScope(scope);
        dependency.setClassifier(classifier);
        return dependency;
    }

    public static Dependency createSource(Dependency dependency) {
        if ("pom".equals(dependency.getType())) {
            return null;
        }
        Dependency sourceDependency = dependency.clone();
        sourceDependency.setClassifier("sources");
        return sourceDependency;
    }

    public static String getGav(Dependency dependency) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(dependency.getGroupId());
        buffer.append(':');
        buffer.append(dependency.getArtifactId());
        buffer.append(':');
        buffer.append(dependency.getVersion());
        return buffer.toString();
    }
}

