/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.java.maven.impl;

import io.github.mmm.code.java.maven.api.MavenConstants;
import io.github.mmm.code.java.maven.impl.MavenLocalRepositoryLocator;
import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;

public class MavenResolver
implements ModelResolver,
MavenConstants {
    private final File localRepository;

    public MavenResolver() {
        this(MavenLocalRepositoryLocator.getDefaultLocalRepository());
    }

    public MavenResolver(File localRepository) {
        this.localRepository = localRepository;
        if (!this.localRepository.isDirectory()) {
            throw new IllegalStateException("Directory not found: " + this.localRepository.getPath());
        }
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) {
        File pomFile = this.resolveFile(groupId, artifactId, version, null, "pom");
        return new FileModelSource(pomFile);
    }

    File resolveArtifact(Dependency dependency) {
        return this.resolveFile(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType());
    }

    File resolvePom(Dependency dependency) {
        return this.resolveFile(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), "pom");
    }

    private File resolveFile(String groupId, String artifactId, String version, String classifier, String type) {
        File groupFolder = new File(this.localRepository, groupId.replace('.', '/'));
        File artifactFolder = new File(groupFolder, artifactId);
        File versionFolder = new File(artifactFolder, version);
        StringBuilder pomFilename = new StringBuilder(artifactId);
        pomFilename.append('-');
        pomFilename.append(version);
        if (classifier != null && !"pom".equals(type)) {
            pomFilename.append('-');
            pomFilename.append(classifier);
        }
        pomFilename.append('.');
        pomFilename.append(type);
        return new File(versionFolder, pomFilename.toString());
    }

    public ModelSource resolveModel(Parent parent) {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(Dependency dependency) {
        File pomFile = this.resolvePom(dependency);
        return new FileModelSource(pomFile);
    }

    public void addRepository(Repository repository) {
    }

    public void addRepository(Repository repository, boolean replace) {
    }

    public ModelResolver newCopy() {
        return this;
    }
}

