/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.java.maven.api;

import io.github.mmm.code.java.maven.api.MavenConstants;
import java.io.File;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class ModelHelper
implements MavenConstants {
    public static File getSourceDirectory(Model model) {
        String srcDir;
        String sourceDirectory = "src/main/java";
        Build build = model.getBuild();
        if (build != null && (srcDir = build.getSourceDirectory()) != null) {
            sourceDirectory = srcDir;
        }
        return ModelHelper.getDirectory(model, sourceDirectory);
    }

    public static File getTestSourceDirectory(Model model) {
        String testSrcDir;
        String testSourceDirectory = "src/test/java";
        Build build = model.getBuild();
        if (build != null && (testSrcDir = build.getTestSourceDirectory()) != null) {
            testSourceDirectory = testSrcDir;
        }
        return ModelHelper.getDirectory(model, testSourceDirectory);
    }

    public static File getBuildDirectory(Model model) {
        String buildDir;
        String buildDirectory = "target";
        Build build = model.getBuild();
        if (build != null && (buildDir = build.getDirectory()) != null) {
            buildDirectory = buildDir;
        }
        return ModelHelper.getDirectory(model, buildDirectory);
    }

    public static File getOutputDirectory(Model model) {
        String outDir;
        String outputDirectory = "target/classes";
        Build build = model.getBuild();
        if (build != null && (outDir = build.getOutputDirectory()) != null) {
            outputDirectory = outDir;
        }
        return ModelHelper.getDirectory(model, outputDirectory);
    }

    private static File getDirectory(Model model, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(model.getPomFile().getParentFile(), path);
    }

    public static File getTestOutputDirectory(Model model) {
        String testOutDir;
        String testOutputDirectory = "target/test-classes";
        Build build = model.getBuild();
        if (build != null && (testOutDir = build.getTestOutputDirectory()) != null) {
            testOutputDirectory = testOutDir;
        }
        return ModelHelper.getDirectory(model, testOutputDirectory);
    }

    public static String getGav(Model model) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(model.getGroupId());
        buffer.append(':');
        buffer.append(model.getArtifactId());
        buffer.append(':');
        buffer.append(model.getVersion());
        return buffer.toString();
    }

    public static String getGav(Parent parent) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(parent.getGroupId());
        buffer.append(':');
        buffer.append(parent.getArtifactId());
        buffer.append(':');
        buffer.append(parent.getVersion());
        return buffer.toString();
    }
}

