/*
 * Decompiled with CFR 0.152.
 */
package io.github.mmm.code.java.maven.impl;

import io.github.mmm.code.java.maven.api.MavenConstants;
import io.github.mmm.code.java.maven.impl.MavenBridgeImpl;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLocalRepositoryLocator
implements MavenConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MavenLocalRepositoryLocator.class);

    public static File getDefaultLocalRepository() {
        File home = new File(System.getProperty("user.home"));
        File m2 = new File(home, ".m2");
        File localRepo = new File(m2, "repository");
        return localRepo;
    }

    public static File getLocalRepository(MavenBridgeImpl pomReader) {
        File localRepo;
        String localRepository = System.getenv("M2_REPO");
        if (localRepository != null && (localRepo = new File(localRepository)).isDirectory()) {
            return localRepo;
        }
        CodeSource codeSource = Model.class.getProtectionDomain().getCodeSource();
        if (codeSource != null) {
            URL location = codeSource.getLocation();
            try {
                Model model;
                String groupId;
                File pomFile;
                File source = new File(location.toURI());
                File versionFolder = source.getParentFile();
                File localRepo2 = MavenLocalRepositoryLocator.findLocalRepository(versionFolder);
                if (localRepo2 == null && source.isFile() && (pomFile = pomReader.findPom(source)) != null && (groupId = MavenLocalRepositoryLocator.getGroupId(model = pomReader.readModel(pomFile))) != null) {
                    File artifactFolder = versionFolder.getParentFile();
                    int dotIndex = 0;
                    File parent = artifactFolder;
                    while (dotIndex >= 0) {
                        parent = parent.getParentFile();
                        dotIndex = groupId.indexOf(46, dotIndex + 1);
                    }
                    return parent;
                }
                if (localRepo2 == null) {
                    localRepo2 = MavenLocalRepositoryLocator.getDefaultLocalRepository();
                }
                return localRepo2;
            }
            catch (URISyntaxException e) {
                LOG.warn("Illegal code source location {}.", (Object)location, (Object)e);
            }
        }
        return MavenLocalRepositoryLocator.getDefaultLocalRepository();
    }

    private static String getGroupId(Model model) {
        Parent parent;
        String groupId = model.getGroupId();
        if (groupId == null && (parent = model.getParent()) != null) {
            groupId = parent.getGroupId();
        }
        return groupId;
    }

    private static File findLocalRepository(File folder) {
        if (folder == null) {
            return null;
        }
        File parent = folder.getParentFile();
        if (folder.getName().equals("repository")) {
            if (parent.getName().equals(".m2")) {
                return folder;
            }
            if (!folder.getPath().replace('\\', '/').contains("/repository/")) {
                return folder;
            }
        }
        return MavenLocalRepositoryLocator.findLocalRepository(parent);
    }
}

