/*
 * Decompiled with CFR 0.152.
 */
package io.github.mannam11.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.mannam11.exception.ReplicateException;
import io.github.mannam11.internal.RequestBuilder;
import io.github.mannam11.internal.ResponseHandler;
import io.github.mannam11.internal.Validator;
import io.github.mannam11.model.request.PredictionRequest;
import io.github.mannam11.model.response.PredictionResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ReplicateClient {
    private final String apiKey;
    private final OkHttpClient okHttpClient;
    private final ObjectMapper objectMapper;
    private static final String BASE_URL = "https://api.replicate.com/v1/models/%s/%s/predictions";

    private ReplicateClient(Builder builder) {
        if (builder.apiKey == null || builder.apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key must not be null or empty");
        }
        this.apiKey = builder.apiKey;
        this.okHttpClient = builder.okHttpClient != null ? builder.okHttpClient : new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).build();
        this.objectMapper = new ObjectMapper();
    }

    public PredictionResponse predict(PredictionRequest predictionRequest) {
        PredictionResponse predictionResponse;
        block8: {
            Validator.validatePredictionRequest(predictionRequest);
            String requestBody = this.objectMapper.writeValueAsString((Object)predictionRequest);
            Request httpRequest = RequestBuilder.build(predictionRequest, requestBody, this.apiKey, BASE_URL);
            System.out.println("httpRequest : " + httpRequest.toString());
            Call call = this.okHttpClient.newCall(httpRequest);
            Response response = call.execute();
            try {
                predictionResponse = ResponseHandler.handle(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ReplicateException("Network error occurred: " + e.getMessage(), e);
                }
            }
            response.close();
        }
        return predictionResponse;
    }

    public static class Builder {
        private String apiKey;
        private OkHttpClient okHttpClient;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public ReplicateClient build() {
            return new ReplicateClient(this);
        }
    }
}

