/*
 * Decompiled with CFR 0.152.
 */
package io.github.mannam11.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.mannam11.exception.ReplicateException;
import io.github.mannam11.internal.RequestBuilder;
import io.github.mannam11.internal.ResponseHandler;
import io.github.mannam11.internal.Validator;
import io.github.mannam11.model.request.PredictionRequest;
import io.github.mannam11.model.response.FileUploadResponse;
import io.github.mannam11.model.response.PredictionResponse;
import io.github.mannam11.utils.UrlValidationUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ReplicateClient {
    private final String apiKey;
    private final OkHttpClient okHttpClient;
    private final ObjectMapper objectMapper;

    private ReplicateClient(Builder builder) {
        if (builder.apiKey == null || builder.apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key must not be null or empty");
        }
        this.apiKey = builder.apiKey;
        this.okHttpClient = builder.okHttpClient != null ? builder.okHttpClient : new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).build();
        this.objectMapper = new ObjectMapper();
    }

    public PredictionResponse predict(PredictionRequest predictionRequest) {
        Validator.validatePredictionRequest(predictionRequest);
        if (this.requiresFileUpload(predictionRequest)) {
            this.uploadInputImage(predictionRequest);
        }
        return this.sendPredictionRequest(predictionRequest);
    }

    private boolean requiresFileUpload(PredictionRequest request) {
        Map<String, Object> input = request.getInput();
        if (!input.containsKey("input_image")) {
            return false;
        }
        return !this.checkForInputImage(input);
    }

    private void uploadInputImage(PredictionRequest request) {
        Object imageValue = request.getInput().get("input_image");
        if (imageValue == null) {
            throw new ReplicateException("Missing input_image value for upload.");
        }
        File file = new File(imageValue.toString());
        Request uploadRequest = RequestBuilder.buildFileUploadRequest(file, this.apiKey);
        Call call = this.okHttpClient.newCall(uploadRequest);
        try (Response response = call.execute();){
            FileUploadResponse uploadResponse = ResponseHandler.handleResponse(response, FileUploadResponse.class);
            request.getInput().put("input_image", uploadResponse.getUrls().getGet());
        }
        catch (IOException e) {
            throw new ReplicateException("Failed to upload input image: " + e.getMessage(), e);
        }
    }

    private PredictionResponse sendPredictionRequest(PredictionRequest request) {
        PredictionResponse predictionResponse;
        block8: {
            String requestBody = this.objectMapper.writeValueAsString((Object)request);
            Request predictionHttpRequest = RequestBuilder.build(request, requestBody, this.apiKey);
            Call call = this.okHttpClient.newCall(predictionHttpRequest);
            Response response = call.execute();
            try {
                predictionResponse = ResponseHandler.handleResponse(response, PredictionResponse.class);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ReplicateException("Prediction request failed: " + e.getMessage(), e);
                }
            }
            response.close();
        }
        return predictionResponse;
    }

    private boolean checkForInputImage(Map<String, Object> input) {
        boolean isValid = UrlValidationUtil.isValidUrl(input.get("input_image").toString());
        return input.containsKey("input_image") && isValid;
    }

    public static class Builder {
        private String apiKey;
        private OkHttpClient okHttpClient;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public ReplicateClient build() {
            return new ReplicateClient(this);
        }
    }
}

