/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_parser.scripts.patterns;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.Parameter;
import io.github.marcperez06.java_parser.core.JavaParserWrapper;
import io.github.marcperez06.java_parser.core.factory.ParametersFactory;
import io.github.marcperez06.java_utilities.reflection.ReflectionUtils;
import io.github.marcperez06.java_utilities.strings.StringUtils;
import java.lang.reflect.Field;
import java.util.List;

public class BuilderPatternGenerator {
    protected Class<?> baseClass;
    protected Class<?> destinationClass;
    protected JavaParserWrapper parser;
    private String className;
    private String packageName;
    private String packageScope;

    public BuilderPatternGenerator(Class<?> baseClass) {
        this.baseClass = baseClass;
        this.className = baseClass.getSimpleName() + "Builder";
        this.packageName = baseClass.getPackage().getName() + ".builder";
        this.parser = new JavaParserWrapper(this.className, this.packageName);
        this.setPackageScope("main");
    }

    public BuilderPatternGenerator(Class<?> baseClass, String packageName) {
        this.baseClass = baseClass;
        this.className = baseClass.getSimpleName() + "Builder";
        this.packageName = packageName;
        this.parser = new JavaParserWrapper(this.className, this.packageName);
        this.setPackageScope("main");
    }

    public void setPackageScope(String packageScope) {
        if (packageScope != null) {
            this.packageScope = packageScope;
            this.parser.setPackageScope(this.packageScope);
        }
    }

    public void execute() {
        if (this.className != null && !this.className.isEmpty()) {
            this.generateBuilder();
        }
    }

    private void generateBuilder() {
        if (this.parser != null) {
            List fields = ReflectionUtils.getFieldsOfClass(this.baseClass);
            this.parser.generateClass();
            this.parser.addImport(this.baseClass.getCanonicalName());
            this.createProperties(fields);
            String constructorBody = "this.buildedObject = null;";
            this.parser.createConstructor(constructorBody, null, Modifier.Keyword.PUBLIC);
            this.createGettersAndSettersMethods(fields);
            this.createBuildMethod(fields);
            this.parser.deleteAndSaveClass();
        }
    }

    private void createProperties(List<Field> fields) {
        this.parser.createVariable("buildedObject", this.baseClass.getSimpleName(), Modifier.Keyword.PRIVATE);
        for (Field field : fields) {
            this.createProperty(field);
        }
    }

    private void createGettersAndSettersMethods(List<Field> fields) {
        for (Field field : fields) {
            this.createGetMethod(field);
            this.createSetMethod(field);
        }
    }

    private void createProperty(Field field) {
        String propertyName = field.getName();
        Class propertyType = ReflectionUtils.getGenericTypeOfField((Field)field);
        this.parser.createVariable(propertyName, propertyType, Modifier.Keyword.PRIVATE);
    }

    private void createGetMethod(Field field) {
        String methodName = field.getName();
        String methodBody = "return this." + methodName + ";";
        Class paramType = ReflectionUtils.getGenericTypeOfField((Field)field);
        this.parser.createMethodIfNotExist(methodName, methodBody, null, paramType, Modifier.Keyword.PUBLIC);
    }

    private void createSetMethod(Field field) {
        String methodName = field.getName();
        String methodBody = "this." + methodName + " = " + methodName + ";";
        methodBody = methodBody + "return this;";
        Class paramType = ReflectionUtils.getGenericTypeOfField((Field)field);
        List<Parameter> parameters = ParametersFactory.createListWithOneParameter(methodName, paramType);
        this.parser.createMethodIfNotExist(methodName, methodBody, parameters, this.className, Modifier.Keyword.PUBLIC);
    }

    private void createBuildMethod(List<Field> fields) {
        String methodName = "build";
        String returnType = this.baseClass.getSimpleName();
        String methodBody = "this.buildedObject = new " + returnType + "();";
        for (Field field : fields) {
            methodBody = methodBody + this.createSetBuildedObjectPropertyForMethodBody(field);
        }
        methodBody = methodBody + "return this.buildedObject;";
        this.parser.createMethodIfNotExist(methodName, methodBody, null, returnType, Modifier.Keyword.PUBLIC);
    }

    private String createSetBuildedObjectPropertyForMethodBody(Field field) {
        String propertyName = field.getName();
        String methodBody = "if (this." + propertyName + " != null) {";
        methodBody = methodBody + "this.buildedObject.set" + StringUtils.capitalizeWord((String)propertyName) + "(this." + propertyName + ");";
        methodBody = methodBody + "}";
        return methodBody;
    }

    public static void generateBuilder(Class<?> baseClass, String ... packageScope) {
        String packageName = baseClass.getPackage().getName() + ".builder";
        BuilderPatternGenerator.generatBuilder(baseClass, packageName, packageScope);
    }

    public static void generatBuilder(Class<?> baseClass, String packageName, String ... packageScope) {
        BuilderPatternGenerator generator = new BuilderPatternGenerator(baseClass, packageName);
        if (packageScope != null && packageScope.length > 0) {
            generator.setPackageScope(packageScope[0]);
        }
        generator.execute();
    }
}

