/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_parser.core;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.github.marcperez06.java_parser.core.CallableParser;
import java.util.List;
import java.util.Optional;

class ConstructorsParser
extends CallableParser {
    private String constructorName;

    public ConstructorsParser(ClassOrInterfaceDeclaration classToParse, String constructorName) {
        super(classToParse);
        this.constructorName = constructorName;
    }

    public ConstructorDeclaration createConstructorDeclaration(Modifier.Keyword ... modifiers) {
        ConstructorDeclaration constructor = new ConstructorDeclaration();
        constructor.setModifiers(Modifier.createModifierList((Modifier.Keyword[])modifiers));
        constructor.setName(this.constructorName);
        return constructor;
    }

    public ConstructorDeclaration createConstructorDeclaration(List<Parameter> parameters, Modifier.Keyword ... modifiers) {
        ConstructorDeclaration constructor = new ConstructorDeclaration();
        constructor.setModifiers(Modifier.createModifierList((Modifier.Keyword[])modifiers));
        constructor.setName(this.constructorName);
        super.addParametersToCallable((CallableDeclaration<?>)constructor, parameters);
        return constructor;
    }

    public void createConstructor(String body, List<Parameter> parameters, Modifier.Keyword ... modifiers) {
        ConstructorDeclaration constructor;
        if (this.classToParse != null && !this.existConstructor(constructor = this.createConstructorDeclaration(parameters, modifiers))) {
            constructor = this.classToParse.addConstructor(modifiers);
            super.addParametersToCallable((CallableDeclaration<?>)constructor, parameters);
            this.callSuperMethod((CallableDeclaration<?>)constructor, parameters);
            this.addBodyToConstructor(constructor, body);
        }
    }

    public void createDefaultConstructor(Modifier.Keyword modifier) {
        ConstructorDeclaration constructor;
        if (this.classToParse != null && !this.existConstructor(constructor = this.createConstructorDeclaration(modifier))) {
            constructor = this.classToParse.addConstructor(new Modifier.Keyword[]{modifier});
            this.callSuperMethod((CallableDeclaration<?>)constructor);
        }
    }

    public boolean existConstructor(ConstructorDeclaration constructor) {
        boolean existConstructor = false;
        if (this.classToParse != null) {
            List existentConstructors = this.classToParse.getConstructors();
            for (int i = 0; i < existentConstructors.size() && !existConstructor; ++i) {
                ConstructorDeclaration existentConsturctor = (ConstructorDeclaration)existentConstructors.get(i);
                CallableDeclaration.Signature existentConstructorSignature = existentConsturctor.getSignature();
                CallableDeclaration.Signature constructorSignature = constructor.getSignature();
                existConstructor = constructorSignature.equals((Object)existentConstructorSignature);
            }
        }
        return existConstructor;
    }

    public void addBodyToDefaultConstructor(String body) {
        Optional optConstructor;
        if (this.classToParse != null && (optConstructor = this.classToParse.getDefaultConstructor()).isPresent()) {
            ConstructorDeclaration constructor = (ConstructorDeclaration)optConstructor.get();
            this.addBodyToConstructor(constructor, body);
        }
    }

    public void addBodyToConstructor(ConstructorDeclaration constructor, String body) {
        BlockStmt addedBlock;
        if (constructor != null && (addedBlock = this.parseStatement(body)) != null) {
            BlockStmt bodyBlock = constructor.getBody();
            for (Statement statement : addedBlock.getStatements()) {
                bodyBlock.addStatement(statement);
            }
            constructor.setBody(bodyBlock);
        }
    }
}

