/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_parser.core;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.stmt.BlockStmt;
import io.github.marcperez06.java_parser.core.CallableParser;
import java.util.List;

class MethodsParser
extends CallableParser {
    public MethodsParser(ClassOrInterfaceDeclaration classToParse) {
        super(classToParse);
    }

    public void createMethod(String methodName, String methodBody, List<Parameter> parameters, String returnType, Modifier.Keyword ... modifiers) {
        if (this.classToParse != null) {
            MethodDeclaration method = this.createMethodDeclaration(methodName, returnType, modifiers);
            this.fillMethod(method, methodBody, parameters);
            this.addMethod(method);
        }
    }

    public void createMethodIfNotExist(String methodName, String methodBody, List<Parameter> parameters, String returnType, Modifier.Keyword ... modifiers) {
        if (this.classToParse != null) {
            MethodDeclaration method = this.createMethodDeclaration(methodName, returnType, modifiers);
            this.fillMethod(method, methodBody, parameters);
            this.addMethodIfNotExist(method);
        }
    }

    public void createMethod(String methodName, String methodBody, List<Parameter> parameters, Class<?> returnType, Modifier.Keyword ... modifiers) {
        if (this.classToParse != null) {
            MethodDeclaration method = this.createMethodDeclaration(methodName, returnType, modifiers);
            this.fillMethod(method, methodBody, parameters);
            this.addMethod(method);
        }
    }

    public void createMethodIfNotExist(String methodName, String methodBody, List<Parameter> parameters, Class<?> returnType, Modifier.Keyword ... modifiers) {
        if (this.classToParse != null) {
            MethodDeclaration method = this.createMethodDeclaration(methodName, returnType, modifiers);
            this.fillMethod(method, methodBody, parameters);
            this.addMethodIfNotExist(method);
        }
    }

    private void fillMethod(MethodDeclaration method, String methodBody, List<Parameter> classParameters) {
        this.addParametersToCallable((CallableDeclaration<?>)method, classParameters);
        BlockStmt block = super.parseStatement(methodBody);
        this.setBodyMethod(method, block);
    }

    public MethodDeclaration createMethodDeclaration(String methodName, Class<?> returnTypeClass, Modifier.Keyword ... modifiers) {
        MethodDeclaration method = new MethodDeclaration();
        this.setMethodDeclarationNameAndModifiers(method, methodName, modifiers);
        method.setType(returnTypeClass);
        return method;
    }

    public MethodDeclaration createMethodDeclaration(String methodName, String returnType, Modifier.Keyword ... modifiers) {
        MethodDeclaration method = new MethodDeclaration();
        this.setMethodDeclarationNameAndModifiers(method, methodName, modifiers);
        method.setType(returnType);
        return method;
    }

    private void setMethodDeclarationNameAndModifiers(MethodDeclaration methodDeclaration, String methodName, Modifier.Keyword ... modifiers) {
        methodDeclaration.setName(methodName);
        methodDeclaration.setModifiers(modifiers);
    }

    public void setBodyMethod(MethodDeclaration method, BlockStmt block) {
        if (method != null) {
            method.setBody(block);
        }
    }

    public void addMethod(MethodDeclaration method) {
        if (this.classToParse != null) {
            this.classToParse.addMember((BodyDeclaration)method);
        }
    }

    public void addMethodIfNotExist(MethodDeclaration method) {
        if (!this.existMethod(method)) {
            this.classToParse.addMember((BodyDeclaration)method);
        }
    }

    public boolean existMethod(MethodDeclaration method) {
        boolean existMethod = false;
        if (this.classToParse != null) {
            List existentMethods = this.classToParse.getMethods();
            for (int i = 0; i < existentMethods.size() && !existMethod; ++i) {
                MethodDeclaration existentMethod = (MethodDeclaration)existentMethods.get(i);
                CallableDeclaration.Signature existentMethodSignature = existentMethod.getSignature();
                CallableDeclaration.Signature methodSignature = method.getSignature();
                existMethod = methodSignature.equals((Object)existentMethodSignature);
            }
        }
        return existMethod;
    }
}

