/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.api.request;

import io.github.marcperez06.java_utilities.api.request.ResponseTypeHolder;
import java.util.Optional;

public class Response<T>
extends ResponseTypeHolder<T> {
    public static final int INFORMATIVE = 200;
    public static final int SUCCESS = 200;
    public static final int ACCEPTED = 202;
    public static final int UNAUTHORIZED = 401;
    public static final int BAD_REQUEST = 400;
    public static final int NOT_FOUND = 404;
    public static final int SERVER_ERROR = 500;
    private final int statusCode;
    private Optional<String> originalBody;
    private Optional<T> body;
    private Optional<Exception> error;

    public Response(int statusCode) {
        this.statusCode = statusCode;
        this.originalBody = Optional.empty();
        this.body = Optional.empty();
        this.error = Optional.empty();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getOriginalBody() {
        return this.originalBody.get();
    }

    public void setOriginalBody(String jsonResponse) {
        this.originalBody = Optional.ofNullable(jsonResponse);
    }

    public Optional<T> getResponseObject() {
        return this.body;
    }

    public void setResponseObject(T value) {
        this.body = Optional.ofNullable(value);
    }

    public Optional<Exception> getError() {
        return this.error;
    }

    public void setError(Exception e) {
        this.error = Optional.ofNullable(e);
    }

    public boolean statusCodeIs(int expectedStatusCode) {
        return this.statusCode == expectedStatusCode;
    }

    public boolean statusCodeIsBetween(int minExpectedStatusCode, int maxExpectedStatusCode, boolean ... inclusive) {
        boolean isBetweenExpectedStatusCode = false;
        isBetweenExpectedStatusCode = inclusive != null && inclusive.length > 0 && inclusive[0] ? this.statusCode <= maxExpectedStatusCode && this.statusCode >= minExpectedStatusCode : this.statusCode < maxExpectedStatusCode && this.statusCode > minExpectedStatusCode;
        return isBetweenExpectedStatusCode;
    }

    public boolean isInformative() {
        return this.statusCodeIsBetween(99, 200, new boolean[0]);
    }

    public boolean isSuccessful() {
        return this.statusCodeIsBetween(199, 300, new boolean[0]);
    }

    public boolean isSuccess() {
        return this.statusCodeIs(200);
    }

    public boolean isAccepted() {
        return this.statusCodeIs(202);
    }

    public boolean isRedirection() {
        return this.statusCodeIsBetween(299, 400, new boolean[0]);
    }

    public boolean isClientError() {
        return this.statusCodeIsBetween(399, 500, new boolean[0]);
    }

    public boolean isAuthorized() {
        return !this.statusCodeIs(401);
    }

    public boolean isUnauthorized() {
        return this.statusCodeIs(401);
    }

    public boolean isBadRequest() {
        return this.statusCodeIs(400);
    }

    public boolean isNotFound() {
        return this.statusCodeIs(404);
    }

    public boolean isServerError() {
        return this.statusCodeIsBetween(499, 600, new boolean[0]);
    }

    public boolean isInternalServerError() {
        return this.statusCodeIs(500);
    }
}

