/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.api.rest;

import io.github.marcperez06.java_utilities.api.request.Request;
import io.github.marcperez06.java_utilities.api.request.RequestProxy;
import io.github.marcperez06.java_utilities.api.request.Response;
import io.github.marcperez06.java_utilities.api.rest.BaseRestClient;
import io.github.marcperez06.java_utilities.api.rest.exceptions.RestClientException;
import io.github.marcperez06.java_utilities.api.rest.objects.RestGenericObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import kong.unirest.ContentType;
import kong.unirest.GetRequest;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.ObjectMapper;
import kong.unirest.Proxy;
import kong.unirest.Unirest;
import kong.unirest.UnirestParsingException;
import kong.unirest.gson.GsonObjectMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnirestClient
extends BaseRestClient {
    private static final Log log = LogFactory.getLog(UnirestClient.class);
    protected Optional<Proxy> proxy = Optional.empty();
    private ObjectMapper objectMapper = new GsonObjectMapper();

    public UnirestClient() {
        Unirest.config().setObjectMapper(this.objectMapper);
    }

    @Override
    public void verifySsl(boolean verifySsl) {
        Unirest.config().verifySsl(verifySsl);
    }

    @Override
    public void setProxy(RequestProxy requestProxy) {
        this.proxy = Optional.of(new Proxy(requestProxy.getHost(), Integer.valueOf(requestProxy.getPort()), requestProxy.getUsername(), requestProxy.getPassword()));
        this.useProxy();
    }

    @Override
    public void useCertificate() {
        if (!this.certificateFilePath.isPresent() || !this.certificateFilePassword.isPresent()) {
            throw new RestClientException("To use certificate a Certificate File Path and Certificate File Password must be provided.");
        }
        Unirest.config().clientCertificateStore(this.certificateFilePath.get(), this.certificateFilePassword.get());
        this.useCertificate = true;
    }

    @Override
    public void disableCertificate() {
        this.useCertificate = false;
        this.resetConfiguration();
    }

    @Override
    public void useProxy() {
        if (!this.proxy.isPresent()) {
            throw new RestClientException("To use a Proxy, a Proxy configuration must be provided.");
        }
        Unirest.config().proxy(this.proxy.get());
        this.useProxy = true;
    }

    @Override
    public void disableProxy() {
        this.useProxy = false;
        this.resetConfiguration();
    }

    public void setObjectMapper(ObjectMapper mapper) {
        this.objectMapper = mapper;
        Unirest.config().setObjectMapper(mapper);
    }

    public void resetObjectMapper() {
        this.objectMapper = new GsonObjectMapper();
        Unirest.config().setObjectMapper(this.objectMapper);
    }

    private void resetConfiguration() {
        Unirest.shutDown();
        Unirest.config().setObjectMapper(this.objectMapper);
        if (this.useCertificate) {
            this.useCertificate();
        }
        if (this.useProxy) {
            this.useProxy();
        }
    }

    @Override
    public <T> Response<T> send(Request request) {
        HttpResponse unirestResponse = null;
        HttpRequest<?> unirestRequest = this.createRequest(request);
        this.addCredentials(unirestRequest, request);
        this.addRequestParams(unirestRequest, request);
        unirestResponse = request.noResponseObjectNeeded() ? unirestRequest.asEmpty() : unirestRequest.asObject(new RestGenericObject(request.getResponseType()));
        return this.asResponse(unirestResponse);
    }

    private HttpRequest<?> createRequest(Request request) throws RestClientException {
        GetRequest unirestRequest = null;
        switch (request.getMethod()) {
            case GET: {
                unirestRequest = Unirest.get((String)request.getUrl());
                break;
            }
            case POST: {
                unirestRequest = Unirest.post((String)request.getUrl());
                break;
            }
            case PUT: {
                unirestRequest = Unirest.put((String)request.getUrl());
                break;
            }
            case PATCH: {
                unirestRequest = Unirest.patch((String)request.getUrl());
                break;
            }
            case DELETE: {
                unirestRequest = Unirest.delete((String)request.getUrl());
                break;
            }
            default: {
                log.debug((Object)request);
                throw new RestClientException("Unable to determine HttpMethod for Request");
            }
        }
        return unirestRequest;
    }

    private void addCredentials(HttpRequest<?> unirestRequest, Request request) {
        if (request.useCredentials()) {
            if (request.useBearerToken()) {
                String token = request.getCredentials().getToken();
                unirestRequest = unirestRequest.header("Authorization", "Bearer " + token);
            } else {
                String user = request.getCredentials().getUser();
                String password = request.getCredentials().getPassword();
                unirestRequest = unirestRequest.basicAuth(user, password);
            }
        }
    }

    private void addRequestParams(HttpRequest<?> unirestRequest, Request request) {
        unirestRequest.routeParam(request.getRouteParams());
        unirestRequest.queryString(request.getQueryParams());
        unirestRequest.headers(request.getHeaders());
        if (unirestRequest instanceof HttpRequestWithBody) {
            if (request.sendAsForm()) {
                this.sendBodyAsFormData(request, (HttpRequest)unirestRequest);
            } else {
                unirestRequest = ((HttpRequestWithBody)unirestRequest).body(request.getBody());
            }
        }
    }

    private void sendBodyAsFormData(Request request, HttpRequest unirestRequest) {
        HttpRequestWithBody body = (HttpRequestWithBody)unirestRequest;
        Map map = (Map)request.getBody();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof File) {
                try {
                    File file = (File)value;
                    FileInputStream inputStream = new FileInputStream(file);
                    body.field(key, (InputStream)inputStream, ContentType.MULTIPART_FORM_DATA, file.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                continue;
            }
            body.field(key, value);
        }
    }

    private <T> Response<T> asResponse(HttpResponse<T> unirestResponse) {
        Response<Object> response = new Response<Object>(unirestResponse.getStatus());
        response.setResponseObject(unirestResponse.getBody());
        if (unirestResponse.getParsingError().isPresent()) {
            response.setOriginalBody(((UnirestParsingException)unirestResponse.getParsingError().get()).getOriginalBody());
            response.setError((Exception)unirestResponse.getParsingError().get());
        }
        return response;
    }
}

