/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.batch;

import io.github.marcperez06.java_utilities.logger.Logger;
import java.io.File;
import java.util.Arrays;

public class Batch {
    private static final String WINDOWS_SHELL = "cmd.exe";
    private static final String C_PARAMETER = "/c";
    private static final String VISUAL_MODE = "start";
    private static final String WAIT_MODE = "/wait";
    private static final int MAX_TIME = 500;
    private Runtime currentApplication = null;
    private Process currentProcess = null;
    private boolean waitMode = false;

    public Runtime getCurrentApplication() {
        return this.currentApplication;
    }

    public Process getCurrentProcess() {
        return this.currentProcess;
    }

    public void executeBat(String pathOfBat, String ... arguments) {
        this.executeBat(pathOfBat, false, arguments);
    }

    public void executeBat(String pathOfBat, boolean visualMode, String ... arguments) {
        String command = this.createCommandForFile(pathOfBat, arguments);
        this.executeCommandInCmd(command, visualMode);
    }

    public void executePowershellScript(String pathOfScript, boolean visualMode, String ... arguments) {
        String command = this.createCommandForFile(pathOfScript, arguments);
        this.executeCommandInPowerShell(command, visualMode);
    }

    private String createCommandForFile(String pathOfile, String ... arguments) {
        String command = null;
        try {
            String scriptArguments;
            File script = new File(pathOfile);
            String string = scriptArguments = arguments != null ? " " + this.clearArguments(arguments) : "";
            if (script.exists()) {
                this.waitMode = true;
                command = pathOfile + scriptArguments;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return command;
    }

    private String clearArguments(String ... arguments) {
        String clearedArguments = Arrays.toString(arguments).replaceAll("\\[", "");
        clearedArguments = clearedArguments.replaceAll("\\]", "");
        clearedArguments = clearedArguments.replaceAll(", ", "");
        return clearedArguments;
    }

    public void executeCommandInCmd(String command) {
        this.executeCommandInCmd(command, false);
    }

    public void executeCommandInCmd(String command, boolean visualMode) {
        String commandToExecute = this.constructCommandToExecuteInCmd(command, visualMode);
        this.executeCommand(commandToExecute);
    }

    public void executeCommandInPowerShell(String command) {
        this.executeCommandInPowerShell(command, false);
    }

    public void executeCommandInPowerShell(String command, boolean visualMode) {
        String commandToExecute = this.constructCommandToExecuteInPowershell(command, visualMode);
        this.executeCommand(commandToExecute);
    }

    private String constructCommandToExecuteInCmd(String command, boolean visualMode) {
        String commandToExecute = "";
        String cmdCommand = "";
        if (visualMode) {
            cmdCommand = "cmd.exe /c";
            cmdCommand = cmdCommand + (visualMode ? " start" : "");
            cmdCommand = cmdCommand + (this.waitMode ? " /wait" : "");
        }
        if (command != null && !command.isEmpty()) {
            commandToExecute = visualMode ? cmdCommand + " " + command : command;
        }
        return commandToExecute;
    }

    private String constructCommandToExecuteInPowershell(String command, boolean visualMode) {
        String commandToExecute = "";
        String powerShellCommand = "cmd.exe /c";
        powerShellCommand = powerShellCommand + " powershell -ExecutionPolicy RemoteSigned -noprofile";
        if (visualMode) {
            powerShellCommand = powerShellCommand + (visualMode ? " -noninteractive" : "");
        }
        if (command != null && !command.isEmpty()) {
            commandToExecute = powerShellCommand + " " + command;
        }
        return commandToExecute;
    }

    public void executeCommand(String command) {
        this.currentApplication = Runtime.getRuntime();
        if (command != null && !command.isEmpty()) {
            Logger.println("Command to execute --> " + command);
            try {
                Logger.println("Starting command");
                this.currentProcess = this.currentApplication.exec(command);
                Logger.println("Finishing command");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Logger.println("The command is empty or null");
        }
    }

    public void waitUntilCurrentProcessIsFinished() {
        this.waitUntilCurrentProcessIsFinished(500);
    }

    public void waitUntilCurrentProcessIsFinished(int maxTime) {
        for (int count = 0; this.currentProcessIsNotFinished() && count < maxTime; ++count) {
        }
    }

    public int waitFor() {
        int result = -1;
        try {
            if (this.currentProcess != null) {
                result = this.currentProcess.waitFor();
                Logger.println("------ wait for ....");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.waitMode = false;
        return result;
    }

    public boolean currentProcessIsNotFinished() {
        return !this.currentProcessIsFinished();
    }

    public boolean currentProcessIsFinished() {
        boolean isFinished = false;
        boolean isAlive = this.currentProcess.isAlive();
        boolean haveExitValue = false;
        try {
            int exitValue = this.currentProcess.exitValue();
            Logger.println("Exit Value: " + exitValue);
            haveExitValue = exitValue > Integer.MIN_VALUE && exitValue < Integer.MAX_VALUE;
            isFinished = !isAlive && haveExitValue;
        }
        catch (Exception e) {
            haveExitValue = false;
        }
        return isFinished;
    }
}

