/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.crypto;

import io.github.marcperez06.java_utilities.crypto.CryptoUtils;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class AESCrypto {
    private static final String ENCRYPT_ALGORITHM = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int SALT_LENGTH_BYTE = 16;
    private static final int AES_KEY_BIT = 256;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private Cipher cipher;

    public AESCrypto() {
        this(ENCRYPT_ALGORITHM);
    }

    public AESCrypto(String algorithm) {
        try {
            this.cipher = Cipher.getInstance(algorithm);
        }
        catch (Throwable e) {
            this.cipher = null;
            e.printStackTrace();
        }
    }

    private boolean chiperIsNotNull() {
        return this.cipher != null;
    }

    public SecretKey getAESKey(int keysize) throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(keysize, SecureRandom.getInstanceStrong());
        return keyGen.generateKey();
    }

    public SecretKey getAESKeyFromPassword(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        return secret;
    }

    public String encrypt(String plainText, String password) {
        String encryptText = "";
        if (this.chiperIsNotNull()) {
            try {
                byte[] salt = CryptoUtils.getRandomNonce(16);
                byte[] iv = CryptoUtils.getRandomNonce(12);
                SecretKey aesKeyFromPassword = this.getAESKeyFromPassword(password, salt);
                GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
                this.cipher.init(1, (Key)aesKeyFromPassword, gcmParameterSpec);
                byte[] cipherText = this.cipher.doFinal(plainText.getBytes(UTF_8));
                int encryptSize = iv.length + salt.length + cipherText.length;
                byte[] cipherTextWithIvSalt = ByteBuffer.allocate(encryptSize).put(iv).put(salt).put(cipherText).array();
                encryptText = Base64.getEncoder().encodeToString(cipherTextWithIvSalt);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Can not encrypt, because AES Chiper is Null");
        }
        return encryptText;
    }

    public String decrypt(String encryptText, String password) {
        String decryptText = "";
        if (this.chiperIsNotNull()) {
            try {
                byte[] decode = Base64.getDecoder().decode(encryptText.getBytes(UTF_8));
                ByteBuffer bufferBytes = ByteBuffer.wrap(decode);
                byte[] iv = new byte[12];
                bufferBytes.get(iv);
                byte[] salt = new byte[16];
                bufferBytes.get(salt);
                byte[] cipherText = new byte[bufferBytes.remaining()];
                bufferBytes.get(cipherText);
                SecretKey aesKeyFromPassword = this.getAESKeyFromPassword(password, salt);
                GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
                this.cipher.init(2, (Key)aesKeyFromPassword, gcmParameterSpec);
                byte[] plainText = this.cipher.doFinal(cipherText);
                decryptText = new String(plainText, UTF_8);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Can not decrypt, because AES Chiper is Null");
        }
        return decryptText;
    }

    public void encryptFile(String fromFile, String toFile, String password) {
        if (this.chiperIsNotNull()) {
            try {
                byte[] fileContentInBytes = Files.readAllBytes(Paths.get(ClassLoader.getSystemResource(fromFile).toURI()));
                String fileContent = new String(fileContentInBytes, UTF_8);
                String encryptString = this.encrypt(fileContent, password);
                byte[] encryptedText = encryptString.getBytes(UTF_8);
                Path path = Paths.get(toFile, new String[0]);
                Files.write(path, encryptedText, new OpenOption[0]);
            }
            catch (Exception e) {
                System.out.print("Can not encrypt the file " + fromFile);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can not encrypt file, because AES Chiper is Null");
        }
    }

    public String decryptFileUsingAES(String fromEncryptedFile, String password) {
        String decryptFile = "";
        if (this.chiperIsNotNull()) {
            try {
                byte[] fileContentInBytes = Files.readAllBytes(Paths.get(fromEncryptedFile, new String[0]));
                String fileContent = new String(fileContentInBytes, UTF_8);
                decryptFile = this.decrypt(fileContent, password);
            }
            catch (Exception e) {
                System.out.print("Can not decrypt the file " + fromEncryptedFile);
                e.printStackTrace();
            }
        } else {
            System.out.println("Can not decrypt file, because AES Chiper is Null");
        }
        return decryptFile;
    }
}

