/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.crypto;

import io.github.marcperez06.java_utilities.crypto.AESCrypto;
import java.security.SecureRandom;
import java.util.ArrayList;

public class CryptoUtils {
    private static AESCrypto aes = new AESCrypto();

    private CryptoUtils() {
    }

    public static byte[] getRandomNonce(int numBytes) {
        byte[] nonce = new byte[numBytes];
        new SecureRandom().nextBytes(nonce);
        return nonce;
    }

    public static String transformByteToToHexadecimal(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            result.append(String.format("%02x", b));
        }
        return result.toString();
    }

    public static String hexadecimalWithBlockSize(byte[] bytes, int blockSize) {
        String hex = CryptoUtils.transformByteToToHexadecimal(bytes);
        blockSize *= 2;
        ArrayList<String> result = new ArrayList<String>();
        int size = hex.length();
        for (int index = 0; index < size; index += blockSize) {
            int endIndex = Math.min(index + blockSize, size);
            result.add(hex.substring(index, endIndex));
        }
        return ((Object)result).toString();
    }

    public static String encryptUsingAES(String plainText, String password) {
        return aes.encrypt(plainText, password);
    }

    public static String decryptUsingAES(String encryptText, String password) {
        return aes.decrypt(encryptText, password);
    }

    public static void encryptFileUsingAES(String fromFile, String toFile, String password) {
        aes.encryptFile(fromFile, toFile, password);
    }

    public static String decryptFileUsingAES(String fromEncryptedFile, String password) {
        return aes.decryptFileUsingAES(fromEncryptedFile, password);
    }
}

