/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.csv;

import io.github.marcperez06.java_utilities.collection.list.ListUtils;
import io.github.marcperez06.java_utilities.file.FileUtils;
import io.github.marcperez06.java_utilities.strings.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Csv {
    private String splitter;
    private String csvPath;
    private List<String> lines = new ArrayList<String>();
    private Map<String, List<String>> content = new HashMap<String, List<String>>();

    public Csv(String csvPath) {
        this(csvPath, ",");
    }

    public Csv(String csvPath, String splitter) {
        this.splitter = splitter;
        this.setPath(csvPath);
    }

    public String getPath() {
        return this.csvPath;
    }

    public void setPath(String csvPath) {
        this.csvPath = csvPath;
        this.readCsv();
    }

    public List<String> getLines() {
        return this.lines;
    }

    public Map<String, List<String>> getContent() {
        return this.content;
    }

    private void readCsv() {
        this.lines = FileUtils.getStringListOfFile(this.csvPath);
        this.content = FileUtils.getMapOfCsv(this.csvPath);
    }

    public Map<String, List<String>> getContentByColumWithValue(String columnName, String value) {
        HashMap<String, List<String>> partialContent = new HashMap<String, List<String>>();
        List<String> columnValues = this.content.get(columnName);
        if (columnValues != null && !columnValues.isEmpty()) {
            List<Integer> indexList = ListUtils.getIndexListOfObjectInList(columnValues, value);
            for (Map.Entry<String, List<String>> entry : this.content.entrySet()) {
                List<String> csvValues = this.getValuesByIndex(this.content.get(entry.getKey()), indexList);
                partialContent.put(entry.getKey(), csvValues);
            }
        }
        return partialContent;
    }

    private List<String> getValuesByIndex(List<String> values, List<Integer> indexes) {
        ArrayList<String> valuesByIndex = new ArrayList<String>();
        if (!values.isEmpty() && !indexes.isEmpty()) {
            for (Integer index : indexes) {
                valuesByIndex.add(values.get(index));
            }
        }
        return valuesByIndex;
    }

    public String getKeysLine() {
        return StringUtils.concatListOfString(this.getKeys(), this.splitter + " ");
    }

    public List<String> getKeys() {
        ArrayList<String> columns = new ArrayList<String>();
        for (String key : this.content.keySet()) {
            columns.add(key);
        }
        return columns;
    }

    public String getRowLine(int index) {
        return StringUtils.concatListOfString(this.getRow(index), this.splitter + " ");
    }

    public List<String> getRow(int index) {
        ArrayList<String> row = new ArrayList<String>();
        if (index >= 0) {
            for (Map.Entry<String, List<String>> entry : this.content.entrySet()) {
                String value = "";
                if (index < entry.getValue().size()) {
                    value = entry.getValue().get(index);
                }
                row.add(value);
            }
        }
        return row;
    }

    public Map<String, String> getRowContent(int index) {
        HashMap<String, String> rowContent = new HashMap<String, String>();
        if (index >= 0) {
            for (Map.Entry<String, List<String>> entry : this.content.entrySet()) {
                String value = "";
                if (index < entry.getValue().size()) {
                    value = entry.getValue().get(index);
                }
                rowContent.put(entry.getKey(), value);
            }
        }
        return rowContent;
    }
}

