/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.database;

import io.github.marcperez06.java_utilities.database.Database;
import io.github.marcperez06.java_utilities.database.SqlObject;
import io.github.marcperez06.java_utilities.database.interfaces.IDAO;
import io.github.marcperez06.java_utilities.database.utils.DatabaseUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDAO
implements IDAO {
    protected String url;
    protected String user;
    protected String password;
    protected Database db;

    public BaseDAO() {
        this.db = null;
    }

    public BaseDAO(String url, String user, String password) {
        this.createDatabaseConnection(url, user, password);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCredentials(String user, String password) {
        this.user = user;
        this.password = password;
    }

    protected boolean haveAccessToDB() {
        return this.db != null;
    }

    @Override
    public void createDatabaseConnection(String url, String user, String password) {
        this.setUrl(url);
        this.setCredentials(user, password);
        this.createDatabaseConnection();
    }

    @Override
    public void createDatabaseConnection() {
        try {
            this.db = this.createDatabaseObject();
            if (this.db.getConnection() == null) {
                this.db = null;
            }
        }
        catch (Exception e) {
            this.db = null;
        }
    }

    protected abstract Database createDatabaseObject();

    @Override
    public int insert(SqlObject sqlObject) {
        int result = -1;
        if (this.haveAccessToDB()) {
            result = this.insertInDB(sqlObject);
        }
        return result;
    }

    protected abstract int insertInDB(SqlObject var1);

    @Override
    public int update(SqlObject sqlObject) {
        int result = -1;
        if (this.haveAccessToDB()) {
            result = this.updateInDB(sqlObject);
        }
        return result;
    }

    protected abstract int updateInDB(SqlObject var1);

    private <T> Method getWhereConditionMethodOfPK(T pk) {
        Method method = null;
        if (pk != null) {
            try {
                Class<?> clazz = pk.getClass();
                method = clazz.getMethod("getWhereCondition", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = null;
                e.printStackTrace();
            }
            catch (SecurityException e) {
                method = null;
                e.printStackTrace();
            }
        }
        return method;
    }

    protected <T> boolean deleteUsingPK(T pk) {
        boolean delete = false;
        try {
            Method method = this.getWhereConditionMethodOfPK(pk);
            if (method != null) {
                SqlObject sqlObject = (SqlObject)method.invoke(pk, new Object[0]);
                int result = this.delete(sqlObject);
                delete = result >= 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return delete;
    }

    @Override
    public int delete(SqlObject sqlObject) {
        int result = -1;
        if (this.haveAccessToDB()) {
            result = this.deleteInDB(sqlObject);
        }
        return result;
    }

    protected abstract int deleteInDB(SqlObject var1);

    protected <T> List<T> returnListOfData(SqlObject sqlObject, Class<T> returnClass) {
        List<Object> data = new ArrayList();
        if (this.haveAccessToDB()) {
            this.select(sqlObject);
            ResultSet resultSet = this.db.getResultSet();
            data = DatabaseUtils.getListFromResultSet(resultSet, returnClass);
        }
        return data;
    }

    protected <T, P> T selectUsingPK(Class<T> returnClass, P pk) {
        Object classToReturn = null;
        try {
            Constructor<T> constructor = returnClass.getConstructor(new Class[0]);
            classToReturn = constructor.newInstance(new Object[0]);
            Method method = this.getWhereConditionMethodOfPK(pk);
            if (method != null && this.existUsingPK(pk)) {
                SqlObject sqlObject = (SqlObject)method.invoke(pk, new Object[0]);
                this.select(sqlObject);
                ResultSet rs = this.db.getResultSet();
                DatabaseUtils.fillFromResultSet(rs, classToReturn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classToReturn;
    }

    @Override
    public void select(SqlObject sqlObject) {
        if (this.haveAccessToDB()) {
            this.selectInDB(sqlObject);
        }
    }

    protected abstract void selectInDB(SqlObject var1);

    protected <T> boolean existUsingPK(T pk) {
        boolean exist = false;
        try {
            Method method = this.getWhereConditionMethodOfPK(pk);
            if (method != null) {
                SqlObject sqlObject = (SqlObject)method.invoke(pk, new Object[0]);
                exist = this.exist(sqlObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exist;
    }

    @Override
    public boolean exist(SqlObject sqlObject) {
        boolean result = false;
        if (this.haveAccessToDB()) {
            result = this.existInDB(sqlObject);
        }
        return result;
    }

    protected abstract boolean existInDB(SqlObject var1);

    protected boolean getExistResult(String sql, SqlObject sqlObject) {
        boolean exist = false;
        try {
            this.db.executePreparedQuery(sql, sqlObject.getWhereParameters());
            ResultSet resultSet = this.db.getResultSet();
            while (resultSet.next()) {
                int result = resultSet.getInt("exist");
                exist = result >= 1;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            exist = false;
        }
        return exist;
    }

    protected <T> int numRegistersUsingPK(T pk) {
        int numRegisters = 0;
        try {
            Method method = this.getWhereConditionMethodOfPK(pk);
            if (method != null) {
                SqlObject sqlObject = (SqlObject)method.invoke(pk, new Object[0]);
                numRegisters = this.numRegisters(sqlObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return numRegisters;
    }

    @Override
    public int numRegisters(SqlObject sqlObject) {
        int numRegisters = 0;
        if (this.haveAccessToDB()) {
            numRegisters = this.numRegistersInDB(sqlObject);
        }
        return numRegisters;
    }

    protected abstract int numRegistersInDB(SqlObject var1);

    protected int getNumRegisters(String sql, SqlObject sqlObject) {
        int numRegisters = 0;
        try {
            this.db.executePreparedQuery(sql, sqlObject.getWhereParameters());
            ResultSet resultSet = this.db.getResultSet();
            while (resultSet.next()) {
                numRegisters = resultSet.getInt("numRegisters");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            numRegisters = 0;
        }
        return numRegisters;
    }
}

