/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.database.factory;

import io.github.marcperez06.java_utilities.database.mysql.MysqlDatabase;
import io.github.marcperez06.java_utilities.database.oracle.OracleDatabase;
import io.github.marcperez06.java_utilities.database.sql.SqlDatabase;
import java.util.Map;

public class DatabaseFactory {
    private DatabaseFactory() {
    }

    public static MysqlDatabase createMysqlDatabase(String url, String user, String password) {
        return new MysqlDatabase(url, user, password);
    }

    public static OracleDatabase createOracleDatabase(String url, String user, String password) {
        return new OracleDatabase(url, user, password);
    }

    public static OracleDatabase createOracleDatabaseThin(String url, String user, String password) {
        return new OracleDatabase("thin", url, user, password);
    }

    public static OracleDatabase createOracleDatabaseOci(String url, String user, String password) {
        return new OracleDatabase("oci", url, user, password);
    }

    public static SqlDatabase createSqlDatabase(String url, String database, String user, String password) {
        return new SqlDatabase(url, database, user, password);
    }

    public static SqlDatabase createSqlDatabase(Map<String, String> connectionSettings) {
        return new SqlDatabase(connectionSettings);
    }
}

