/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.database.mysql;

import io.github.marcperez06.java_utilities.database.BaseDAO;
import io.github.marcperez06.java_utilities.database.Database;
import io.github.marcperez06.java_utilities.database.SqlObject;
import io.github.marcperez06.java_utilities.database.factory.DatabaseFactory;
import io.github.marcperez06.java_utilities.strings.StringUtils;

public class MysqlDAO
extends BaseDAO {
    public MysqlDAO() {
    }

    public MysqlDAO(String url, String user, String password) {
        super(url, user, password);
    }

    @Override
    protected Database createDatabaseObject() {
        return DatabaseFactory.createMysqlDatabase(this.url, this.user, this.password);
    }

    @Override
    protected int insertInDB(SqlObject sqlObject) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO " + sqlObject.getTableName());
        sqlBuilder.append("(" + sqlObject.getConcatFields() + ") VALUES");
        sqlBuilder.append("(");
        for (int i = 0; i < sqlObject.getFieldsSize(); ++i) {
            sqlBuilder.append("?, ");
        }
        String sql = sqlBuilder.toString();
        sql = StringUtils.cutStringWithOtherString(sql, ", ", 0);
        sql = sql + ");";
        int insert = this.db.executePreparedSQL(sql, sqlObject.getParameters());
        System.out.println("------------ MysqlDAO.java ------------ SQL INSERT: " + sql);
        return insert;
    }

    @Override
    protected int updateInDB(SqlObject sqlObject) {
        int i;
        String sql = "UPDATE " + sqlObject.getTableName();
        sql = sql + " SET ";
        for (i = 0; i < sqlObject.getFieldsSize(); ++i) {
            sql = sql + sqlObject.getField(i) + " = ?, ";
        }
        sql = StringUtils.cutStringWithOtherString(sql, ", ", 0);
        sql = sql + " WHERE 1 = 1";
        for (i = 0; i < sqlObject.getWhereFieldsSize(); ++i) {
            sql = sql + " AND " + sqlObject.getWhereField(i) + " = ?";
        }
        sql = sql + ";";
        System.out.println("------------ MysqlDAO.java ------------ SQL UPDATE: " + sql);
        int update = this.db.executePreparedSQL(sql, sqlObject.getJoinedParameters());
        return update;
    }

    @Override
    protected int deleteInDB(SqlObject sqlObject) {
        String sql = "DELETE " + sqlObject.getTableName();
        sql = sql + " WHERE 1 = 1";
        for (int i = 0; i < sqlObject.getWhereFieldsSize(); ++i) {
            sql = sql + " AND " + sqlObject.getWhereField(i) + " = ?";
        }
        sql = sql + ";";
        System.out.println("------------ MysqlDAO.java ------------ SQL DELETE: " + sql);
        int delete = this.db.executePreparedSQL(sql, sqlObject.getWhereParameters());
        return delete;
    }

    @Override
    protected void selectInDB(SqlObject sqlObject) {
        String auxFields = "*";
        if (sqlObject.haveFields()) {
            auxFields = sqlObject.getConcatFields();
        }
        String sql = "SELECT " + auxFields;
        sql = sql + " FROM " + sqlObject.getTableName();
        sql = sql + " WHERE 1 = 1";
        for (int i = 0; i < sqlObject.getWhereFieldsSize(); ++i) {
            sql = sql + " AND " + sqlObject.getWhereField(i) + " = ?";
        }
        sql = sql + ";";
        System.out.println("------------ MysqlDAO.java ------------ SQL SELECT: " + sql);
        this.db.executePreparedQuery(sql, sqlObject.getWhereParameters());
    }

    @Override
    protected boolean existInDB(SqlObject sqlObject) {
        String sql = "SELECT COUNT(*) as exist";
        sql = sql + " FROM " + sqlObject.getTableName();
        sql = sql + " WHERE 1 = 1";
        for (int i = 0; i < sqlObject.getWhereFieldsSize(); ++i) {
            sql = sql + " AND " + sqlObject.getWhereField(i) + " = ?";
        }
        sql = sql + ";";
        System.out.println("------------ MysqlDAO.java ------------ SQL EXIST: " + sql);
        boolean exist = this.getExistResult(sql, sqlObject);
        return exist;
    }

    @Override
    protected int numRegistersInDB(SqlObject sqlObject) {
        int numRegisters = 0;
        String sql = "SELECT COUNT(*) as numRegisters";
        sql = sql + " FROM " + sqlObject.getTableName();
        sql = sql + " WHERE 1 = 1";
        for (int i = 0; i < sqlObject.getWhereFieldsSize(); ++i) {
            sql = sql + " AND " + sqlObject.getWhereField(i) + " = ?";
        }
        sql = sql + ";";
        System.out.println("------------ MysqlDAO.java ------------ SQL COUNT: " + sql);
        numRegisters = super.getNumRegisters(sql, sqlObject);
        return numRegisters;
    }
}

