/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.database.oracle;

import io.github.marcperez06.java_utilities.database.Database;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleDriver;

public class OracleDatabase
extends Database {
    private static final String ORACLE_THIN = "jdbc:oracle:thin:";
    private static final String ORACLE_OCI = "jdbc:oracle:oci:";
    private String type;

    public OracleDatabase() {
        this.setThinType();
    }

    public OracleDatabase(String url, String user, String password) {
        super(url, user, password);
        this.setThinType();
    }

    public OracleDatabase(String databaseType, String url, String user, String password) {
        super(url, user, password);
        this.setType(databaseType);
    }

    private void setType(String type) {
        if (type.equalsIgnoreCase("oci")) {
            this.setOciType();
        } else {
            this.setThinType();
        }
    }

    public void setThinType() {
        this.type = "thin";
    }

    public boolean isThin() {
        return this.type.equals("thin");
    }

    public void setOciType() {
        this.type = "oci";
    }

    public boolean isOci() {
        return this.type.equals("oci");
    }

    @Override
    public void createConnection(String url, String user, String password) throws SQLException, IllegalAccessException, ClassNotFoundException, Exception {
        if (this.connection == null || this.connection.isClosed()) {
            try {
                DriverManager.registerDriver((Driver)new OracleDriver());
                String connectionUrl = this.getConnectionUrl(url);
                this.connection = DriverManager.getConnection(connectionUrl, user, password);
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.connection = null;
            }
        }
    }

    private String getConnectionUrl(String url) {
        String connectionUrl = url;
        if (this.isThin()) {
            if (!url.startsWith(ORACLE_THIN)) {
                connectionUrl = ORACLE_THIN + url;
            }
        } else if (this.isOci() && !url.startsWith(ORACLE_OCI)) {
            connectionUrl = ORACLE_OCI + url;
        }
        return connectionUrl;
    }
}

