/*
 * Decompiled with CFR 0.152.
 */
package io.github.marcperez06.java_utilities.excel;

import io.github.marcperez06.java_utilities.collection.list.ListUtils;
import io.github.marcperez06.java_utilities.logger.Logger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class Excel {
    private String excelPath;
    private Workbook workbook;
    private List<Sheet> sheets;

    public Excel(String excelPath) {
        this.setExcelPath(excelPath);
        this.readAllExcel();
        this.sheets = this.getSheets();
    }

    public String getExcelPath() {
        return this.excelPath;
    }

    public void setExcelPath(String excelPath) {
        this.excelPath = excelPath;
    }

    public List<Sheet> getSheets() {
        ArrayList<Sheet> sheetsList = new ArrayList<Sheet>();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            sheetsList.add(this.workbook.getSheetAt(i));
        }
        return sheetsList;
    }

    private void readAllExcel() {
        try {
            if (!this.excelPath.isEmpty()) {
                File excelFile = new File(this.excelPath);
                this.workbook = WorkbookFactory.create((File)excelFile);
            }
        }
        catch (EncryptedDocumentException e) {
            this.workbook = null;
            e.printStackTrace();
            Logger.error(e.getMessage());
        }
        catch (InvalidFormatException e) {
            this.workbook = null;
            e.printStackTrace();
            Logger.error(e.getMessage());
        }
        catch (IOException e) {
            this.workbook = null;
            e.printStackTrace();
            Logger.error(e.getMessage());
        }
    }

    public <T> List<T> readSheetInListFormat(String sheetName) {
        int sheetIndex = this.getSheetIndexByName(sheetName);
        return this.readSheetInListFormat(sheetIndex);
    }

    public int getSheetIndexByName(String name) {
        int index = -1;
        boolean found = false;
        Sheet auxSheet = null;
        for (int i = 0; i < this.sheets.size() && !found; ++i) {
            auxSheet = this.sheets.get(i);
            if (!auxSheet.getSheetName().equalsIgnoreCase(name)) continue;
            found = true;
            index = i;
        }
        return index;
    }

    public <T> List<T> readSheetInListFormat(int sheetIndex) {
        List<Object> list = new ArrayList();
        if (sheetIndex > -1) {
            Sheet sheet = this.sheets.get(sheetIndex);
            if (!this.excelPath.isEmpty() && sheet != null) {
                list = this.readRowsLine(sheet);
            }
        }
        return list;
    }

    private <T> List<T> readRowsLine(Sheet sheet) {
        ArrayList list = new ArrayList();
        int rowCount = 0;
        short cellSize = 0;
        for (Row row : sheet) {
            if (rowCount == 0) {
                cellSize = row.getLastCellNum();
            }
            this.readCells(list, row, rowCount, cellSize);
            ++rowCount;
        }
        return list;
    }

    private <T> void readCells(List<T> list, Row row, int rowCount, int cellSize) {
        for (int cellCount = 0; cellCount < cellSize; ++cellCount) {
            Cell cell = row.getCell(cellCount);
            T value = this.getCellValue(cell);
            list.add(value);
        }
    }

    public <T> Map<String, List<T>> readSheet(String sheetName) {
        int sheetIndex = this.getSheetIndexByName(sheetName);
        return this.readSheet(sheetIndex);
    }

    public <T> Map<String, List<T>> readSheet(int sheetIndex) {
        Map<String, List<T>> map = new HashMap<String, List<T>>();
        if (sheetIndex > -1) {
            Sheet sheet = this.sheets.get(sheetIndex);
            if (!this.excelPath.isEmpty() && sheet != null) {
                map = this.readRows(sheet);
            }
        }
        return map;
    }

    private <T> Map<String, List<T>> readRows(Sheet sheet) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        ArrayList<String> mapKeys = new ArrayList<String>();
        int rowCount = 0;
        short cellSize = 0;
        for (Row row : sheet) {
            if (rowCount == 0) {
                cellSize = row.getLastCellNum();
            }
            this.readCells(mapKeys, map, row, rowCount, cellSize);
            ++rowCount;
        }
        return map;
    }

    private <T> void readCells(List<String> mapKeys, Map<String, List<T>> map, Row row, int rowCount, int cellSize) {
        for (int cellCount = 0; cellCount < cellSize; ++cellCount) {
            String key;
            Cell cell = row.getCell(cellCount);
            if (rowCount == 0) {
                key = (String)this.getCellValue(cell);
                map.put(key, new ArrayList());
                mapKeys.add(key);
                continue;
            }
            key = mapKeys.get(cellCount);
            T value = this.getCellValue(cell);
            map.get(key).add(value);
        }
    }

    public <T> T getCellValue(Cell cell) {
        Object value = null;
        if (cell != null) {
            switch (cell.getCellTypeEnum()) {
                case BOOLEAN: {
                    value = cell.getBooleanCellValue();
                    break;
                }
                case STRING: {
                    value = cell.getRichStringCellValue().getString();
                    break;
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        value = cell.getDateCellValue();
                        break;
                    }
                    cell.setCellType(CellType.STRING);
                    value = cell.getRichStringCellValue().getString();
                    break;
                }
                case FORMULA: {
                    value = cell.getCellFormula();
                    break;
                }
                case BLANK: {
                    value = null;
                    break;
                }
                default: {
                    value = null;
                }
            }
        }
        return (T)value;
    }

    public List<String> getSheetNames() {
        ArrayList<String> sheetNames = new ArrayList<String>();
        for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
            sheetNames.add(this.workbook.getSheetAt(i).getSheetName());
        }
        return sheetNames;
    }

    public Sheet getSheetByName(String name) {
        Sheet sheet = null;
        Sheet auxSheet = null;
        boolean found = false;
        for (int i = 0; i < this.sheets.size() && !found; ++i) {
            auxSheet = this.sheets.get(i);
            if (!auxSheet.getSheetName().equalsIgnoreCase(name)) continue;
            found = true;
            sheet = auxSheet;
        }
        return sheet;
    }

    public List<String> getSheetHeaders(Sheet sheet) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator rows = sheet.rowIterator();
        Row row = (Row)rows.next();
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            Cell cell = (Cell)cells.next();
            result.add(cell.getStringCellValue());
        }
        return result;
    }

    public List<String> getSheetColumnByIndex(Sheet sheet, int index) {
        ArrayList<String> column = new ArrayList<String>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            Cell cell = row.getCell(index);
            column.add((String)this.getCellValue(cell));
        }
        return column;
    }

    public Cell getCellInRowByColumnName(Sheet sheet, Row row, String columnName) {
        int column = this.getSheetHeaders(sheet).indexOf(columnName);
        return row.getCell(column);
    }

    public Map<String, List<String>> getRowsFromColumnValue(int sheetIndex, String columnName, String value) {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        if (!this.sheets.isEmpty() && sheetIndex < this.sheets.size()) {
            Sheet sheet = this.sheets.get(sheetIndex);
            map = this.getRowsFromColumnValue(sheet, columnName, value);
        }
        return map;
    }

    public Map<String, List<String>> getRowsFromColumnValue(String sheetName, String columnName, String value) {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        Sheet sheet = this.getSheetByName(sheetName);
        if (sheet != null) {
            map = this.getRowsFromColumnValue(sheet, columnName, value);
        }
        return map;
    }

    private Map<String, List<String>> getRowsFromColumnValue(Sheet sheet, String columnName, String value) {
        List<String> mapKeys = this.getSheetHeaders(sheet);
        Map map = this.initializeExcelMap(mapKeys);
        boolean found = false;
        if (ListUtils.existObjectInList(mapKeys, columnName)) {
            int columIndex = mapKeys.indexOf(columnName);
            for (int i = 1; i < sheet.getLastRowNum() && !found; ++i) {
                Row row = sheet.getRow(i);
                Cell cell = row.getCell(columIndex);
                String cellValue = (String)this.getCellValue(cell);
                if (!value.equals(cellValue)) continue;
                found = true;
                this.readCells(mapKeys, map, row, i, row.getLastCellNum());
            }
        }
        return map;
    }

    private Map<String, List<String>> initializeExcelMap(List<String> mapKeys) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String key : mapKeys) {
            map.put(key, new ArrayList());
        }
        return map;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void close() {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

